package com.foresee.open.user.sdk;

import com.foresee.ftcsp.common.core.rest.RestResponse;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.user.vo.GetUserByOpenIdRequest;
import com.foresee.open.user.vo.UserBaseInfo;
import com.foresee.open.user.vo.wechat.*;


/**
 * @author: yaosong@foresee.com.cn
 * @date: 2018/7/24
 */
public interface WechatUserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "凭应用ID和用户ID获取微信用户标识")
    WechatOpenidQueryResponseVO getOpenidByAppidAndUserid(@ApiParam("") WechatOpenidQueryRequestVO request);

    @OpenApi(level = OpenApiLevel.APP, name = "微信用户登陆")
    WechatUserInfo login(@ApiParam("") WechatUserLoginParam wechatUserLoginParam);

    @OpenApi(level = OpenApiLevel.APP, name = "通过易号码查询微信信息")
    WechatSimpleInfoList queryOpenIdByEncode(@ApiParam("encode")String encode);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId解绑微信信息")
    void unbind(WechatSimpleInfo wechatSimpleInfo);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId获取用户信息")
    UserBaseInfo getByOpenId(@ApiParam("") GetUserByOpenIdRequest request);

}
