package com.foresee.open.user.sdk;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.user.vo.AccountModifyPassword;
import com.foresee.open.user.vo.GetUserByOpenIdRequest;
import com.foresee.open.user.vo.HeadImage;
import com.foresee.open.user.vo.LoginName;
import com.foresee.open.user.vo.ModifyPasswordBySmsCodeRequest;
import com.foresee.open.user.vo.Uid;
import com.foresee.open.user.vo.UpdateUserRequest;
import com.foresee.open.user.vo.UserBaseInfo;
import com.foresee.open.user.vo.UserInfo;
import com.foresee.open.user.vo.UserRegistration;
import com.foresee.open.user.vo.reponse.LoginUserInfo;
import com.foresee.open.user.vo.request.AppUserInfo;
import com.foresee.open.user.vo.user.reponse.UserIds;

/**
 * OrgApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public interface UserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "注册用户")
    UserIds register(@ApiParam("") UserRegistration userRegistration);

    @OpenApi(level = OpenApiLevel.APP, name = "创建用户")
    Uid create(@ApiParam("") UserRegistration userRegistration);

    @OpenApi(level = OpenApiLevel.APP, name = "凭用户ID查询用户信息")
    UserInfo getByUserId(@ApiParam("") Uid uid);

    @OpenApi(level = OpenApiLevel.APP, name = "凭登录账号查询用户信息")
    UserInfo getByLoginName(@ApiParam("") LoginName loginName);

    @OpenApi(level = OpenApiLevel.APP, name = "凭旧密码修改用户密码")
    String modifyPassword(@ApiParam("") AccountModifyPassword modifyPassword);

    @OpenApi(level = OpenApiLevel.APP, name = "凭短信验证码修改用户密码")
    String modifyPasswordBySmsCode(@ApiParam("") ModifyPasswordBySmsCodeRequest modifyPasswordBySmsCodeRequest);


    @OpenApi(level = OpenApiLevel.APP, name = "设置用户头像图片")
    HeadImage setHeadImage(@ApiParam("userId") Long userId,
                           @ApiParam("headImage") String headImage,
                           @ApiParam("imageFormat") String imageFormat);

    @OpenApi(level = OpenApiLevel.APP, name = "获取用户头像图片")
    HeadImage getHeadImage(@ApiParam("userId") Long userId);

    @OpenApi(level = OpenApiLevel.APP, name = "更新用户的基本信息")
    String update(@ApiParam("") UpdateUserRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "用String类型的用户id换取Long类型")
    Uid getUserIdByExternalUserId(@ApiParam("externalUserId") String externalUserId);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId获取用户信息")
    UserBaseInfo getByOpenId(@ApiParam("") GetUserByOpenIdRequest request);


    @OpenApi(level = OpenApiLevel.APP, name = "凭应用的用户ID登录")
    LoginUserInfo loginByAppUserId(@ApiParam("") AppUserInfo appUserInfo);

    @OpenApi(level = OpenApiLevel.APP, name = "通过token获取用户信息")
    UserInfo getUserByToken(@ApiParam("token") String token);


    @OpenApi(level = OpenApiLevel.APP, name = "凭旧用户ID查询用户信息")
    UserInfo getByGuid(@ApiParam("guid") String guid);

}
