package com.foresee.open.user.sdk;


import com.foresee.ftcsp.common.core.page.PageQueryResult;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.user.vo.SecOrgDTO;
import com.foresee.open.user.vo.UserBaseInfo;
import com.foresee.open.user.vo.sync.SyncPage;
import com.foresee.open.user.vo.sync.SyncUserOrg;
import com.foresee.open.user.vo.sync.SyncUserWechat;

/**
 * SyncApi
 *
 * @author liyuming@foresee.com.cn
 * @version 1.0
 * @time 2018/8/31 0031
 */
public interface SyncApi extends UserBaseOpenApi{


    @OpenApi(level = OpenApiLevel.APP, name = "分页同步用户信息")
    PageResult<UserBaseInfo> syncUser(@ApiParam("") SyncPage syncPage);


    @OpenApi(level = OpenApiLevel.APP, name = "分页同步企业信息")
    PageResult<SecOrgDTO> syncOrg(@ApiParam("") SyncPage syncPage);

    @OpenApi(level = OpenApiLevel.APP, name = "分页同步用户与企业信息")
    PageResult<SyncUserOrg> syncUserOrg(@ApiParam("") SyncPage syncPage);

    @OpenApi(level = OpenApiLevel.APP, name = "分页同步用户与微信信息")
    PageResult<SyncUserWechat> syncUserWechat(@ApiParam("") SyncPage syncPage);
}
