package com.foresee.open.user.sdk;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.user.vo.*;

/**
 * OrgApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public interface OrgApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "创建企业")
    OrgId create(@ApiParam("") SecOrgDTO secOrgDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "修改企业")
    void update(@ApiParam("") SecOrgDTO secOrgDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "查询企业信息")
    SecOrgDTO get(@ApiParam("orgId") Long orgId);

    @OpenApi(level = OpenApiLevel.APP, name = "删除企业信息")
    void delete(@ApiParam("orgId") Long orgId);

    @OpenApi(level = OpenApiLevel.APP, name = "查询企业信息")
    OrgInfoList getByUser(@ApiParam("userId") Long userId,
                          @ApiParam("channel") String channel,
                          @ApiParam("areaCode") String areaCode);
    
    @OpenApi(level = OpenApiLevel.APP, name = "根据用户查询企业信息，从cus库里拿数据")
    QueryOrgByUserResponse queryByUser(@ApiParam("") QueryOrgByUserRequest request);


    @OpenApi(level = OpenApiLevel.APP, name = "根据纳税人识别号查询企业信息")
    SecOrgDTO getByTaxpayerId(@ApiParam("taxpayerId")String taxpayerId);


    @OpenApi(level = OpenApiLevel.APP, name = "根据用户查询企业信息，从新表拿数据")
    QueryOrgByUserResponse getByUserInfo(@ApiParam("") QueryOrgByUserRequest request);


}
