package com.foresee.open.user.sdk;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.user.vo.AppOrgId;
import com.foresee.open.user.vo.DeleteAppOrgRequest;
import com.foresee.open.user.vo.OrgId;
import com.foresee.open.user.vo.SecAppOrgDto;
import com.foresee.open.user.vo.SecAppOrgQuery;

/**
 * @Author:liyuming@foresee.com.cn
 * @Description:
 */
public interface ApporgApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name="添加企业与应用的关系")
    String create(@ApiParam("") SecAppOrgDto request);

    @OpenApi(level = OpenApiLevel.APP, name="修改企业与应用的关系")
    String update(@ApiParam("") SecAppOrgDto request);

    @OpenApi(level = OpenApiLevel.APP, name = "删除应用与企业的关系")
    String delete(@ApiParam("") DeleteAppOrgRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "分页查询应用与企业的关系")
    PageResult<SecAppOrgDto> query(SecAppOrgQuery appOrgQuery);

    @OpenApi(level = OpenApiLevel.APP, name = "根据企业ID换取应用企业ID")
    AppOrgId getAppOrgId(@ApiParam("appId") String appId, @ApiParam("orgId") Long orgId);

    @OpenApi(level = OpenApiLevel.APP, name = "根据应用企业ID换取企业id")
    OrgId getOrgId(@ApiParam("appId") String appId, @ApiParam("appOrgId") String appOrgId);
}
