package com.foresee.open.user.sdk;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.GetUserByOpenIdRequest;
import com.foresee.open.user.vo.UserBaseInfo;
import com.foresee.open.user.vo.user.reponse.UserIds;
import com.foresee.open.user.vo.wechat.*;
import com.foresee.open.user.vo.wechat.request.UnbindByUserIdDTO;

/**
 * @author: yaosong@foresee.com.cn
 * @date: 2018/7/24
 */
public interface WechatUserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "凭应用ID和用户ID获取微信用户标识")
    OpenApiResponse<WechatOpenidQueryResponseVO> getOpenidByAppidAndUserid(@ApiParam("") WechatOpenidQueryRequestVO request);


    @OpenApi(level = OpenApiLevel.APP, name = "微信用户登陆")
    OpenApiResponse<WechatUserInfo> login(@ApiParam("") WechatUserLoginParam wechatUserLoginParam);

    @OpenApi(level = OpenApiLevel.APP, name = "通过易号码查询微信信息")
    OpenApiResponse<WechatSimpleInfoList> queryOpenIdByEncode(@ApiParam("encode")String encode);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId解绑微信信息")
    OpenApiResponse<String> unbind(WechatSimpleInfo wechatSimpleInfo);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId获取用户信息")
    OpenApiResponse<UserBaseInfo> getByOpenId(@ApiParam("") GetUserByOpenIdRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "凭unionId查询用户id")
    OpenApiResponse<UserIds> getByUnionId(@ApiParam("unionId") String unionId);

    @OpenApi(level = OpenApiLevel.APP, name = "凭纳税人识别号查询联系人的微信信息")
    OpenApiResponse<WechatGetByTaxpayerIdReponse> getByTaxpayerId(WechatGetByTaxpayerIdRequest wechatGetByTaxpayerIdRequest);

    @OpenApi(level = OpenApiLevel.APP, name = "根据userId获取微信信息")
    OpenApiResponse<WxInfo> getWxInfoByUserId(@ApiParam("userId") String userId);

    @OpenApi(level = OpenApiLevel.APP, name = "解绑用户与微信绑定关系")
    OpenApiResponse unbindByUserId(UnbindByUserIdDTO unbindByUserIdDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "根据uId获取微信信息")
    OpenApiResponse<WxInfo> getByUserId(@ApiParam("userId") Long userId);
}
