package com.foresee.open.user.sdk;

import com.foresee.ftcsp.common.core.rest.RestResponse;
import com.foresee.ftcsp.ftcspmvc.annotation.Var;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.AccountModifyPassword;
import com.foresee.open.user.vo.GetUserByOpenIdRequest;
import com.foresee.open.user.vo.HeadImage;
import com.foresee.open.user.vo.LoginName;
import com.foresee.open.user.vo.ModifyPasswordBySmsCodeRequest;
import com.foresee.open.user.vo.Uid;
import com.foresee.open.user.vo.UpdateUserRequest;
import com.foresee.open.user.vo.UserBaseInfo;
import com.foresee.open.user.vo.UserInfo;
import com.foresee.open.user.vo.UserRegistration;
import com.foresee.open.user.vo.reponse.LoginUserInfo;
import com.foresee.open.user.vo.request.AppUserInfo;
import com.foresee.open.user.vo.user.reponse.UserIds;
import com.foresee.open.user.vo.user.request.*;
import com.foresee.open.user.vo.user.reponse.UserTokenDTO;
import com.foresee.open.user.vo.user.request.LoginNameDTO;
import com.foresee.open.user.vo.user.request.ModifyUserPasswordDTO;
import com.foresee.open.user.vo.user.request.ModifyPasswordByGuidDTO;
import com.foresee.open.user.vo.user.request.ModifyPasswordByGuidDTO;
import com.foresee.open.user.vo.user.request.ModifyUserPasswordDTO;
import com.foresee.open.user.vo.user.request.UserCreateRequest;
import javax.validation.Valid;

import javax.validation.Valid;

/**
 * OrgApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public interface UserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "注册用户")
    OpenApiResponse<UserIds> register(@ApiParam("") UserRegistration userRegistration);

    @OpenApi(level = OpenApiLevel.APP, name = "创建用户")
    OpenApiResponse<UserIds> create(@ApiParam("") UserRegistration userRegistration);

    @OpenApi(level = OpenApiLevel.APP, name = "凭用户ID查询用户信息")
    OpenApiResponse<UserInfo> getByUserId(@ApiParam("") Uid uid);

    @OpenApi(level = OpenApiLevel.APP, name = "凭登录账号查询用户信息")
    OpenApiResponse<UserInfo> getByLoginName(@ApiParam("") LoginName loginName);

    @OpenApi(level = OpenApiLevel.APP, name = "凭旧密码修改用户密码")
    OpenApiResponse<String> modifyPassword(@ApiParam("") AccountModifyPassword modifyPassword);

    @OpenApi(level = OpenApiLevel.APP, name = "凭短信验证码修改用户密码")
    OpenApiResponse<String> modifyPasswordBySmsCode(@ApiParam("") ModifyPasswordBySmsCodeRequest modifyPasswordBySmsCodeRequest);


    @OpenApi(level = OpenApiLevel.APP, name = "设置用户头像图片")
    OpenApiResponse<HeadImage> setHeadImage(@ApiParam("userId") Long userId,
                           @ApiParam("headImage") String headImage,
                           @ApiParam("imageFormat") String imageFormat);

    @OpenApi(level = OpenApiLevel.APP, name = "获取用户头像图片")
    OpenApiResponse<HeadImage> getHeadImage(@ApiParam("userId") Long userId);

    @OpenApi(level = OpenApiLevel.APP, name = "更新用户的基本信息")
    OpenApiResponse<String> update(@ApiParam("") UpdateUserRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "用String类型的用户id换取Long类型")
    OpenApiResponse<Uid> getUserIdByExternalUserId(@ApiParam("externalUserId") String externalUserId);

    @OpenApi(level = OpenApiLevel.APP, name = "通过openId获取用户信息")
    OpenApiResponse<UserBaseInfo> getByOpenId(@ApiParam("") GetUserByOpenIdRequest request);


    @OpenApi(level = OpenApiLevel.APP, name = "凭应用的用户ID登录")
    OpenApiResponse<LoginUserInfo> loginByAppUserId(@ApiParam("") AppUserInfo appUserInfo);

    @OpenApi(level = OpenApiLevel.APP, name = "通过token获取用户信息")
    OpenApiResponse<UserInfo> getUserByToken(@ApiParam("token") String token);

    @OpenApi(level = OpenApiLevel.APP, name = "根据手机修改用户信息包括账号信息")
    OpenApiResponse<String> updateUserAndAccountByPhone(@ApiParam("") UpdateUserAndAccountRequest updateUserAndAccountRequest);


    @OpenApi(level = OpenApiLevel.APP, name = "修改用户手机号码")
    OpenApiResponse<String> updatePhone(@ApiParam("") UserUpdatePhoneRequest userUpdatePhoneRequest);


    @OpenApi(level = OpenApiLevel.APP, name = "根据登陆账号获取token")
    OpenApiResponse<UserTokenDTO> getTokenByLoginName(LoginNameDTO loginNameDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "直接修改手机用户密码，并且把随机密码发到用户手机上")
    OpenApiResponse modifyPasswordByPhone(ModifyPasswordByPhoneDTO modifyPasswordByPhoneDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "修改用户的登陆密码")
    OpenApiResponse modifyUserPassword(ModifyUserPasswordDTO modifyUserPasswordDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "凭旧用户ID查询用户信息")
    OpenApiResponse<UserInfo> getByGuid(@ApiParam("guid") String guid);

    @OpenApi(level = OpenApiLevel.APP, name = "根据登陆账号获取用户信息")
    OpenApiResponse<UserInfo> getUserByLoginName(LoginName loginName);

    @OpenApi(level = OpenApiLevel.APP, name = "凭旧密码修改用户密码（通过guid）")
    OpenApiResponse modifyPasswordByGuid(ModifyPasswordByGuidDTO modifyPassword);
    
    @OpenApi(level = OpenApiLevel.APP, name = "根据loginName删除用户相关信息，紧在测试环境可使用")
    OpenApiResponse deleteByLoginName(LoginName loginName);




}
