package com.foresee.open.user.sdk;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.LongId;
import com.foresee.open.user.vo.OrgAppUserCreation;
import com.foresee.open.user.vo.OrgAppUserDeletion;
import com.foresee.open.user.vo.PageAppOrgUserReponse;
import com.foresee.open.user.vo.PageAppOrgUserRequest;
import com.foresee.open.user.vo.orgappuser.request.DeleteByTaxpayerIdRequest;

/**
 * OrgappuserApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public interface OrgappuserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "添加用户与企业的关系")
    OpenApiResponse<LongId> create(@ApiParam("") OrgAppUserCreation creation);

    @OpenApi(level = OpenApiLevel.APP, name = "修改企业与用户的关系")
    OpenApiResponse<String> update(@ApiParam("") OrgAppUserCreation creation);

    @OpenApi(level = OpenApiLevel.APP, name = "删除企业与用户的关系")
    OpenApiResponse<String> delete(@ApiParam("") OrgAppUserDeletion deletion);

    @OpenApi(level = OpenApiLevel.APP, name = "分页查询应用企业用户关系列表")
    OpenApiResponse<PageResult<PageAppOrgUserReponse>> query(@ApiParam("") PageAppOrgUserRequest request);


    @OpenApi(level = OpenApiLevel.APP, name = "根据纳税人识别号删除用户与企业应用的关系")
    OpenApiResponse<String> deleteByTaxpayerId(@ApiParam("") DeleteByTaxpayerIdRequest request);
}
