package com.foresee.open.user.sdk;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.AppUserId;
import com.foresee.open.user.vo.AppUserRequestQuery;
import com.foresee.open.user.vo.DeleteAppUserRequest;
import com.foresee.open.user.vo.SecAppUserDto;
import com.foresee.open.user.vo.UserId;
import com.foresee.open.user.vo.appuser.AppUserQueryEntry;

/**
 * @Author:liyuming@foresee.com.cn
 * @Description:
 */
public interface AppuserApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "添加用户与应用的关系")
    OpenApiResponse<String> create(@ApiParam("") SecAppUserDto request);

    @OpenApi(level = OpenApiLevel.APP, name = "修改用户与应用的关系")
    OpenApiResponse<String> update(@ApiParam("") SecAppUserDto request);

    @OpenApi(level = OpenApiLevel.APP, name = "删除用户与应用的关系")
    OpenApiResponse<String> delete(@ApiParam("") DeleteAppUserRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "分页查询用户与应用的关系列表")
    OpenApiResponse<PageResult<AppUserQueryEntry>> query(@ApiParam("") AppUserRequestQuery request);

    @OpenApi(level = OpenApiLevel.APP, name = "根据用户ID换取应用用户ID")
    OpenApiResponse<AppUserId> getAppUserId(@ApiParam("appId") String appId, @ApiParam("userId") Long userId);

    @OpenApi(level = OpenApiLevel.APP, name = "根据用户ID换取应用用户ID")
    OpenApiResponse<UserId> getUserId(@ApiParam("appId") String appId, @ApiParam("appUserId") String appUserId);
}
