/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.foresee.open.sdk.json.JsonSupport;
import java.io.IOException;

public class JacksonSupport
implements JsonSupport {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JacksonSupport() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public String toString(Object data) {
        try {
            return this.objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> cls) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(cls);
        return this.fromJsonViaJavaType(json, javaType);
    }

    private <T> T fromJsonViaJavaType(String json, JavaType javaType) {
        try {
            return (T)this.objectMapper.readerFor(javaType).readValue(json);
        }
        catch (IOException var3) {
            throw new IllegalStateException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25", var3);
        }
    }

    public JavaType getParametricType(Class<?> paramtricClass, Class<?> elementClass) {
        return this.objectMapper.getTypeFactory().constructParametricType(paramtricClass, new Class[]{elementClass});
    }

    @Override
    public <T> T fromJson(String json, Class<T> klass, Class<?> elementClass) {
        JavaType javaType = this.getParametricType(klass, elementClass);
        return this.fromJsonViaJavaType(json, javaType);
    }
}

