/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client.ssl;

import com.foresee.open.sdk.client.ssl.SSLConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLHelper {
    public static SSLSocketFactory getSSLCertifcation() {
        SSLSocketFactory sslSocketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SSLConfig.getCertificateStandard());
            KeyStore keyStore = SSLHelper.getKeyStore(SSLConfig.getClientCertFile(), SSLConfig.getClientCertPassword(), SSLConfig.getKeyStoreType());
            keyManagerFactory.init(keyStore, SSLConfig.getClientCertPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SSLConfig.getCertificateStandard());
            KeyStore trustStore = SSLHelper.getKeyStore(SSLConfig.getTrustStoreCertFile(), SSLConfig.getTrustStoreCertPassword(), "JKS");
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(SSLConfig.getProtocolType());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sslSocketFactory;
    }

    private static KeyStore getKeyStore(File keyStoreFile, String password, String type) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        FileInputStream is = new FileInputStream(keyStoreFile);
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(is, password.toCharArray());
        ((InputStream)is).close();
        return keyStore;
    }
}

