/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.api;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.AccessTokenHelper;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.ApiParamVO;
import com.foresee.open.sdk.api.ApiResource;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.api.OpenApiVO;
import com.foresee.open.sdk.api.ServiceInfo;
import com.foresee.open.sdk.auth.GatewayConfig;
import com.foresee.open.sdk.auth.vo.AccessToken;
import com.foresee.open.sdk.client.OpenApiFactory;
import com.foresee.open.sdk.client.OpenApiRequest;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.sdk.exception.OpenApiClientException;
import com.foresee.open.sdk.exception.OpenApiCreationException;
import com.foresee.open.sdk.exception.OpenApiResponseException;
import com.foresee.open.sdk.json.Jackson;
import com.foresee.open.sdk.json.JsonKit;
import com.foresee.open.sdk.kit.ClassKit;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class OpenApiInvocationHandler
implements InvocationHandler {
    private ServiceInfo serviceInfo;
    private OpenApiFactory openApiFactory;

    public OpenApiInvocationHandler(OpenApiFactory openApiFactory, ServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
        this.openApiFactory = openApiFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeOpenMethod(proxy, method, args, false);
    }

    private Object invokeOpenMethod(Object proxy, Method method, Object[] args, boolean isRepeat) throws Throwable {
        Object body = this.assembleBody(method, args);
        OpenApiVO openApiVO = this.getOpenApi(method);
        if (GatewayConfig.isSkipGateway()) {
            openApiVO.setLevel(OpenApiLevel.PUBLIC);
            String path = openApiVO.getPath();
            String[] paths = path.split("/");
            openApiVO.setPath("/" + paths[paths.length - 2] + "/" + paths[paths.length - 1]);
        }
        OpenApiRequest request = new OpenApiRequest(openApiVO.getPath());
        if (body != null) {
            request.setRequestObject(body);
        }
        switch (openApiVO.getLevel()) {
            case PUBLIC: {
                this.initializePublic(method, request);
                break;
            }
            case USER: {
                String userToken = this.getUserToken(body);
                this.initializeUser(request, userToken);
                break;
            }
            case APP: {
                this.initializeApp(request);
            }
        }
        if (Strings.isNullOrEmpty((String)request.getHost())) {
            if (!Strings.isNullOrEmpty((String)GatewayConfig.getAddress())) {
                request.setHost(GatewayConfig.getAddress());
            } else {
                throw new OpenApiClientException("API\u7f51\u5173\u5730\u5740\u8fd8\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u8c03\u7528GatewayConfig.setAddress\u65b9\u6cd5\u8bbe\u7f6e\u3002");
            }
        }
        String respText = this.openApiFactory.getOpenHttpClient().post(request);
        Type genericReturnType = method.getGenericReturnType();
        Class<Object> returnType = method.getReturnType();
        OpenApiResponse entireResponse = JsonKit.fromJson(respText, OpenApiResponse.class);
        if (entireResponse.isFailed() && entireResponse.getHead().getErrorCode().equalsIgnoreCase("100100000021") && !isRepeat) {
            AccessTokenHelper.cleanCache();
            return this.invokeOpenMethod(proxy, method, args, true);
        }
        if (returnType.isAssignableFrom(PageResult.class) || !(genericReturnType instanceof ParameterizedTypeImpl)) {
            if (returnType.isAssignableFrom(OpenApiResponse.class)) {
                return entireResponse;
            }
            if (entireResponse.isFailed()) {
                OpenApiResponse.Head head = entireResponse.getHead();
                throw new OpenApiResponseException(head.getErrorCode(), head.getErrorMsg(), head.getRequestId());
            }
            if (returnType.isAssignableFrom(Void.TYPE)) {
                return null;
            }
            return entireResponse.getBody(returnType);
        }
        ParameterizedTypeImpl genericReturnTypeImpl = (ParameterizedTypeImpl)genericReturnType;
        Type type = genericReturnTypeImpl.getActualTypeArguments()[0];
        Object javaBody = entireResponse.getBody();
        if (returnType.isAssignableFrom(OpenApiResponse.class)) {
            Object o = Jackson.fromJson(JsonKit.toString(javaBody), type);
            entireResponse.setBody(o);
            return entireResponse;
        }
        Object o = JsonKit.fromJson(JsonKit.toString(javaBody), returnType, (Class)type);
        return o;
    }

    private String getUserToken(Object body) {
        if (body instanceof Map) {
            return (String)((Map)body).get("userToken");
        }
        throw new IllegalStateException("userToken\u6ca1\u6709\u4f20\u5165");
    }

    private void initializeApp(OpenApiRequest request) {
        AccessToken appAccessToken = AccessTokenHelper.getAppAccessToken(this.openApiFactory, this.serviceInfo.getAppId());
        this.populateRequestByAccessToken(request, appAccessToken);
    }

    private void initializeUser(OpenApiRequest request, String userToken) {
        AccessToken userAccessToken = AccessTokenHelper.getUserAccessToken(this.openApiFactory, this.serviceInfo.getAppId(), userToken);
        this.populateRequestByAccessToken(request, userAccessToken);
    }

    private void populateRequestByAccessToken(OpenApiRequest request, AccessToken userAccessToken) {
        request.setSignKey(userAccessToken.getRandomKey()).setAccessToken(userAccessToken.getAccessToken()).setHost(userAccessToken.getProviderAppURL());
    }

    private Object assembleBody(Method method, Object[] args) {
        ApiParamVO[] apiParams = this.lookupParameterNames(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (apiParams.length == 1 && !this.isSimpleType(parameterTypes[0])) {
            return args[0];
        }
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        for (int i = 0; i < apiParams.length; ++i) {
            String parameterName = apiParams[i].getName();
            Object arg = args[i];
            Class<?> parameterType = parameterTypes[i];
            if (this.isSimpleType(parameterType)) {
                bodyMap.put(parameterName, arg);
                continue;
            }
            Map<String, Object> map = this.beanToMap(arg);
            bodyMap.putAll(map);
        }
        return bodyMap;
    }

    private Map<String, Object> beanToMap(Object arg) {
        if (arg == null) {
            return Collections.emptyMap();
        }
        try {
            return this.doBeanToMap(arg);
        }
        catch (IllegalAccessException e) {
            throw new OpenApiCreationException("bean\u8f6cmap\u9519\u8bef," + JsonKit.toString(arg), e);
        }
    }

    private Map<String, Object> doBeanToMap(Object arg) throws IllegalAccessException {
        Field[] declaredFields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field declaredField : declaredFields = arg.getClass().getDeclaredFields()) {
            String fieldName = declaredField.getName();
            declaredField.setAccessible(true);
            Object value = declaredField.get(arg);
            map.put(fieldName, value);
        }
        return map;
    }

    private boolean isSimpleType(Class<?> klass) {
        return ClassKit.isPrimitiveOrWrapper(klass) || klass == String.class || Map.class.isAssignableFrom(klass) || Collection.class.isAssignableFrom(klass);
    }

    private ApiParamVO[] lookupParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ApiParamVO[] params = new ApiParamVO[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = parameterAnnotations[i]) {
                ApiParamVO apiParamVO;
                if (!(annotation instanceof ApiParam)) continue;
                ApiParam apiParam = (ApiParam)annotation;
                params[i] = apiParamVO = new ApiParamVO().setName(apiParam.value());
            }
        }
        return params;
    }

    private void initializePublic(Method method, OpenApiRequest request) {
        request.setHost(GatewayConfig.getAddress());
        request.setSignKey(this.openApiFactory.getSignKey());
    }

    private OpenApiVO getOpenApi(Method method) {
        OpenApi openApi = method.getAnnotation(OpenApi.class);
        if (openApi == null) {
            String url = this.getPath(method);
            OpenApiLevel level = OpenApiLevel.PUBLIC;
            return new OpenApiVO().setLevel(level).setPath(url);
        }
        String url = openApi.path();
        if (Strings.isNullOrEmpty((String)url)) {
            url = this.getPath(method);
        }
        OpenApiLevel level = openApi.level();
        return new OpenApiVO().setLevel(level).setPath(url);
    }

    private String getPath(Method method) {
        String resource;
        Class<?> declaringClass = method.getDeclaringClass();
        ApiResource apiResource = declaringClass.getAnnotation(ApiResource.class);
        if (apiResource != null) {
            resource = apiResource.value();
        } else {
            String api = declaringClass.getSimpleName().split("Api")[0];
            resource = api.substring(0, 1).toLowerCase() + api.substring(1);
        }
        return "/v1/" + this.serviceInfo.getService() + "/" + resource + "/" + method.getName();
    }
}

