/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit;

import com.foresee.open.sdk.kit.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class ZipUtil {
    private static final int BUFFER_SIZE = 2048;
    public static final String GZIP = "GZIP";
    public static final String ZIP = "ZIP";

    public static String decompress(String encdata, boolean codebyB64) {
        if (encdata == null) {
            return null;
        }
        if (codebyB64) {
            return new String(ZipUtil.decompress(Base64.decode(encdata)));
        }
        return new String(ZipUtil.decompress(encdata.getBytes()));
    }

    public static String compress(String data, boolean codebyB64) {
        if (data == null) {
            return null;
        }
        if (codebyB64) {
            return new String(Base64.encode(ZipUtil.compress(data.getBytes())));
        }
        return new String(ZipUtil.compress(data.getBytes()));
    }

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(data);
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] decompress(byte[] encdata) {
        if (encdata == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        InflaterInputStream inflaterInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int count;
            inputStream = new ByteArrayInputStream(encdata);
            inflaterInputStream = new InflaterInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[2048];
            while ((count = inflaterInputStream.read(data, 0, 2048)) != -1) {
                byteArrayOutputStream.write(data, 0, count);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (inflaterInputStream != null) {
                try {
                    inflaterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String zip(String str, String charset) {
        if (null == str || str.length() <= 0) {
            return str;
        }
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        return Base64.encodeToStr(ZipUtil.compress(ZipUtil.getBytes(str, charset)));
    }

    public static String zip(String str) {
        return ZipUtil.zip(str, Charset.defaultCharset().name());
    }

    public static byte[] zip(byte[] bytes) {
        return ZipUtil.compress(bytes);
    }

    public static String unzip(String str, String charset) {
        if (null == str || str.length() <= 0) {
            return str;
        }
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        return new String(ZipUtil.decompress(Base64.decode(str)), ZipUtil.getCharset(charset));
    }

    public static String gzip(String str, String charset) {
        if (null == str || str.length() <= 0) {
            return str;
        }
        return new String(Base64.encode(ZipUtil.gzip(ZipUtil.getBytes(str, charset))));
    }

    private static byte[] getBytes(String str, String charset) {
        if (null == str || str.length() <= 0) {
            return null;
        }
        return str.getBytes(ZipUtil.getCharset(charset));
    }

    private static Charset getCharset(String charset) {
        Charset charSet = null;
        if (charset != null) {
            charSet = Charset.forName(charset);
        }
        if (charSet == null) {
            charSet = Charset.defaultCharset();
        }
        return charSet;
    }

    public static String gzip(String str) {
        return ZipUtil.gzip(str, Charset.defaultCharset().name());
    }

    public static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(out);
            gos.write(bytes);
            gos.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String ungzip(String str, String charset) {
        if (null == str || str.length() <= 0) {
            return str;
        }
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        byte[] gzipBytes = Base64.decode(str);
        byte[] ungzipBytes = ZipUtil.ungzip(gzipBytes);
        return new String(ungzipBytes, ZipUtil.getCharset(charset));
    }

    public static String ungzip(String str) {
        return ZipUtil.ungzip(str, Charset.defaultCharset().name());
    }

    public static byte[] ungzip(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream gis = null;
        try {
            gis = new GZIPInputStream(in);
            byte[] buffer = new byte[2048];
            int n = 0;
            while ((n = gis.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (gis != null) {
                try {
                    gis.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

