/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.api.AccessTokenHelper;
import com.foresee.open.sdk.auth.AuthHost;
import com.foresee.open.sdk.auth.vo.AccessToken;
import com.foresee.open.sdk.client.OpenApiFactory;
import com.foresee.open.sdk.client.OpenApiHelper;
import com.foresee.open.sdk.client.OpenApiRequest;
import com.foresee.open.sdk.client.OpenHttpClient;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.json.JsonKit;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Map;

public class OpenApiClient {
    private OpenHttpClient openHttpClient;
    private OpenApiFactory openApiFactory;

    public OpenApiClient(String appId, String signKey) {
        this.openApiFactory = new OpenApiFactory(appId, signKey);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, String encryptKey) {
        this.openApiFactory = new OpenApiFactory(appId, signKey, OpenApiConstants.DEFAULT_SIGN_ALGORITHM, encryptKey, OpenApiConstants.DEFAULT_ENCRYPT_ALGORITHM);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        this.openApiFactory = new OpenApiFactory(appId, signKey, signAlgorithm, encryptKey, encryptAlgorithm);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    protected OpenApiClient(OpenApiFactory openApiFactory) {
        this.openApiFactory = openApiFactory;
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public String requestPublic(String url, Object object) {
        String body = JsonKit.toString(object);
        return this.requestPublic(url, body);
    }

    public String requestPublic(String url, String body) {
        OpenApiRequest openApiRequest = this.urlToApiRequest(url).setRequestObject(body).setSignKey(this.openHttpClient.getSignKey());
        return this.openHttpClient.post(openApiRequest);
    }

    public String requestApp(String url, Object object, String providerAppId) {
        String body = JsonKit.toString(object);
        return this.requestApp(url, body, providerAppId);
    }

    public String requestApp(String url, String body, String providerAppId) {
        if (Strings.isNullOrEmpty((String)AuthHost.getAuthHost())) {
            OpenApiRequest openApiRequest = this.urlToApiRequest(url);
            AuthHost.setAuthHost(openApiRequest.getHost());
        }
        AccessToken accessToken = AccessTokenHelper.getAppAccessToken(this.openApiFactory, providerAppId);
        return this.requestByAccessToken(url, body, accessToken);
    }

    private String requestByAccessToken(String url, String body, AccessToken accessToken) {
        OpenApiRequest openApiRequest = this.urlToApiRequest(url).setHost(accessToken.getProviderAppURL()).setAccessToken(accessToken.getAccessToken()).setRequestObject(body).setSignKey(accessToken.getRandomKey());
        return this.openHttpClient.post(openApiRequest);
    }

    public String requestUser(String url, Object object, String providerAppId, String userToken) {
        String body = JsonKit.toString(object);
        return this.requestUser(url, body, providerAppId, userToken);
    }

    public String requestUser(String url, String body, String providerAppId, String userToken) {
        if (Strings.isNullOrEmpty((String)AuthHost.getAuthHost())) {
            OpenApiRequest openApiRequest = this.urlToApiRequest(url);
            AuthHost.setAuthHost(openApiRequest.getHost());
        }
        AccessToken accessToken = AccessTokenHelper.getUserAccessToken(this.openApiFactory, providerAppId, userToken);
        return this.requestByAccessToken(url, body, accessToken);
    }

    private OpenApiRequest urlToApiRequest(String url) {
        URI uri = OpenApiHelper.getUri(url);
        String path = uri.getPath();
        String baseUrl = uri.getScheme() + "://" + uri.getAuthority();
        String query = uri.getQuery();
        Map<String, String> map = OpenApiHelper.queryStringToMap(query);
        return new OpenApiRequest(path).setHost(baseUrl).setQueryMap(map);
    }
}

