package com.foresee.open.user.sdk;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.box.reponse.BoxQueryRealnameReponse;
import com.foresee.open.user.vo.box.request.BoxQueryAllBoundRequest;
import com.foresee.open.user.vo.box.request.BoxUnbindRealnameRequest;

import java.util.List;

/**
 * 绑定实名相关接口
 *
 * @author: yaosong@foresee.com.cn
 * @date: 2018/7/23
 */
public interface RealnameApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "解绑实名用户")
    OpenApiResponse<String> unbind(@ApiParam("") BoxUnbindRealnameRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "查询绑定的实名用户")
    OpenApiResponse<List<BoxQueryRealnameReponse>> query(@ApiParam("") BoxQueryAllBoundRequest request);

}
