package com.foresee.open.user.sdk;

import com.foresee.open.page.vo.PageResult;
import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.DeleteOrgRelationRequest;
import com.foresee.open.user.vo.SecOrgRelationDto;
import com.foresee.open.user.vo.SecOrgRelationQuery;

/**
 * @Author:liyuming@foresee.com.cn
 * @Description:
 */
public interface OrgorgApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "添加企业与企业的关系")
    OpenApiResponse<String> create(@ApiParam("") SecOrgRelationDto request);

    @OpenApi(level = OpenApiLevel.APP, name = "修改企业与企业的关系")
    OpenApiResponse<String> update(@ApiParam("") SecOrgRelationDto request);

    @OpenApi(level = OpenApiLevel.APP, name = "删除企业与企业的关系")
    OpenApiResponse<String> delete(@ApiParam("") DeleteOrgRelationRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "删除企业与企业的关系")
    OpenApiResponse<PageResult<SecOrgRelationDto>> query(@ApiParam("") SecOrgRelationQuery relationQuery);
}
