package com.foresee.open.user.sdk;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.OpenApi;
import com.foresee.open.sdk.api.OpenApiLevel;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.user.vo.*;
import com.foresee.open.user.vo.wechat.OrgByNameVO;

/**
 * OrgApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public interface OrgApi extends UserBaseOpenApi {

    @OpenApi(level = OpenApiLevel.APP, name = "创建企业")
    OpenApiResponse<OrgId> create(@ApiParam("") SecOrgDTO secOrgDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "修改企业")
    OpenApiResponse<String> update(@ApiParam("") SecOrgDTO secOrgDTO);

    @OpenApi(level = OpenApiLevel.APP, name = "查询企业信息")
    OpenApiResponse<SecOrgDTO> get(@ApiParam("orgId") Long orgId);

    @OpenApi(level = OpenApiLevel.APP, name = "删除企业信息")
    OpenApiResponse<String> delete(@ApiParam("orgId") Long orgId);

    @OpenApi(level = OpenApiLevel.APP, name = "查询企业信息")
    OpenApiResponse<OrgInfoList> getByUser(@ApiParam("userId") Long userId,
                                           @ApiParam("channel") String channel,
                                           @ApiParam("areaCode") String areaCode);

    @OpenApi(level = OpenApiLevel.APP, name = "根据用户查询企业信息")
    OpenApiResponse<QueryOrgByUserResponse> queryByUser(@ApiParam("") QueryOrgByUserRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "根据纳税人识别号查询企业信息")
    OpenApiResponse<SecOrgDTO> getByTaxpayerId(@ApiParam("taxpayerId") String taxpayerId);

    @OpenApi(level = OpenApiLevel.APP, name = "根据用户查询企业信息，从新表拿数据")
    OpenApiResponse<QueryOrgByUserResponse> getByUserInfo(@ApiParam("") QueryOrgByUserRequest request);

    @OpenApi(level = OpenApiLevel.APP, name = "凭纳税人名称查询企业信息")
    OpenApiResponse<OrgByNameVO> queryByOrgName(@ApiParam("appId") String appId, @ApiParam("orgName") String orgName);

}
