/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.user.validator;

import com.foresee.open.user.validator.FtcspDataType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Validator {
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,17}$";
    public static final String REGEX_MOBILE = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";
    public static final String REGEX_ID_CARD = "([0-9]{17}([0-9]|X))|([0-9]{15})";
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final String REGEX_IP_ADDR = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    public static final String NORMAL_REGEX_MOBILE = "\\d{11}$";

    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    public static boolean isMobile(String mobile) {
        return Pattern.matches(NORMAL_REGEX_MOBILE, mobile);
    }

    public static boolean isNormalMobile(String mobile) {
        return Pattern.matches(NORMAL_REGEX_MOBILE, mobile);
    }

    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    public static boolean isChinese(String chinese) {
        return Pattern.matches(REGEX_CHINESE, chinese);
    }

    public static boolean isIDCard(String idCard) {
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }

    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    public static boolean isIPAddr(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    public static boolean isPassword(String password) {
        if (password.length() < 6 || password.length() > 32) {
            return false;
        }
        int num = 0;
        num = Pattern.compile("\\d").matcher(password).find() ? num + 1 : num;
        num = Pattern.compile("[a-z]").matcher(password).find() ? num + 1 : num;
        num = Pattern.compile("[A-Z]").matcher(password).find() ? num + 1 : num;
        num = Pattern.compile("[-.!@#$%^&*()+?><]").matcher(password).find() ? num + 1 : num;
        return num >= 3;
    }

    public static boolean isCorrect(String text, FtcspDataType dataType, String ext) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return true;
        }
        if (dataType.equals((Object)FtcspDataType.PASSWORD)) {
            return Validator.isPassword(text);
        }
        if (dataType.equals((Object)FtcspDataType.PHONE)) {
            return Validator.isMobile(text);
        }
        if (dataType.equals((Object)FtcspDataType.EMAIL)) {
            return Validator.isEmail(text);
        }
        if (dataType.equals((Object)FtcspDataType.URL)) {
            return Validator.isUrl(text);
        }
        if (dataType.equals((Object)FtcspDataType.ID_CARD)) {
            return Validator.isIDCard(text);
        }
        if (dataType.equals((Object)FtcspDataType.TIME_STR)) {
            return Validator.isTimeStr(text, ext);
        }
        return true;
    }

    public static boolean isTimeStr(String text, String ext) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(ext);
            sdf.setLenient(false);
            Date parse = sdf.parse(text);
            System.out.println(parse.getTime());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String mobilePhone = "15603004776";
        boolean normalMobile = Validator.isNormalMobile(mobilePhone);
        System.out.println("is mobile phone =" + normalMobile);
    }
}

