/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit.gm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SM3Util {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String ivHexStr = "7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e";
    private static final BigInteger IV = new BigInteger("7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e".replaceAll(" ", ""), 16);
    private static final Integer Tj15 = Integer.valueOf("79cc4519", 16);
    private static final Integer Tj63 = Integer.valueOf("7a879d8a", 16);
    private static final byte[] FirstPadding = new byte[]{-128};
    private static final byte[] ZeroPadding = new byte[1];

    public static String hash(String source) {
        return SM3Util.byteArrayToHexString(SM3Util.hash(source.getBytes()));
    }

    public static byte[] hash(byte[] source) {
        byte[] m1 = SM3Util.padding(source);
        int n = m1.length / 64;
        byte[] vi = IV.toByteArray();
        byte[] vi1 = null;
        int i = 0;
        while (i < n) {
            byte[] b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM3Util.CF(vi, b);
            vi = vi1;
            ++i;
        }
        return vi1;
    }

    public static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            resultSb.append(SM3Util.byteToHexString(b[i]));
            ++i;
        }
        return resultSb.toString();
    }

    private static int T(int j) {
        if (j >= 0 && j <= 15) {
            return Tj15;
        }
        if (j >= 16 && j <= 63) {
            return Tj63;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer FF(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer GG(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer P0(Integer x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static Integer P1(Integer x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    private static byte[] padding(byte[] source) {
        if ((long)source.length >= 0x2000000000000000L) {
            throw new RuntimeException("src data invalid.");
        }
        long l = source.length * 8;
        long k = 448L - (l + 1L) % 512L;
        if (k < 0L) {
            k += 512L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(source);
            baos.write(FirstPadding);
            long i = k - 7L;
            while (i > 0L) {
                baos.write(ZeroPadding);
                i -= 8L;
            }
            baos.write(SM3Util.long2bytes(l));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    private static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
            ++i;
        }
        return bytes;
    }

    private static byte[] CF(byte[] vi, byte[] bi) {
        int a = SM3Util.toInteger(vi, 0);
        int b = SM3Util.toInteger(vi, 1);
        int c = SM3Util.toInteger(vi, 2);
        int d = SM3Util.toInteger(vi, 3);
        int e = SM3Util.toInteger(vi, 4);
        int f = SM3Util.toInteger(vi, 5);
        int g = SM3Util.toInteger(vi, 6);
        int h = SM3Util.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        int i = 0;
        while (i < 16) {
            w[i] = SM3Util.toInteger(bi, i);
            ++i;
        }
        int j = 16;
        while (j < 68) {
            w[j] = SM3Util.P1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
            ++j;
        }
        j = 0;
        while (j < 64) {
            w1[j] = w[j] ^ w[j + 4];
            ++j;
        }
        int j2 = 0;
        while (j2 < 64) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM3Util.T(j2), j2), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM3Util.FF(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM3Util.GG(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM3Util.P0(tt2);
            ++j2;
        }
        byte[] v = SM3Util.toByteArray(a, b, c, d, e, f, g, h);
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = (byte)(v[i2] ^ vi[i2]);
            ++i2;
        }
        return v;
    }

    private static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder("");
        int i = 0;
        while (i < 4) {
            valueStr.append(hexDigits[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(hexDigits[(byte)(source[index * 4 + i] & 0xF)]);
            ++i;
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    private static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
        try {
            baos.write(SM3Util.toByteArray(a));
            baos.write(SM3Util.toByteArray(b));
            baos.write(SM3Util.toByteArray(c));
            baos.write(SM3Util.toByteArray(d));
            baos.write(SM3Util.toByteArray(e));
            baos.write(SM3Util.toByteArray(f));
            baos.write(SM3Util.toByteArray(g));
            baos.write(SM3Util.toByteArray(h));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return "" + hexDigits[d1] + hexDigits[d2];
    }
}

