/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit.gm;

import com.foresee.open.sdk.kit.gm.ByteUtil;
import com.foresee.open.sdk.kit.gm.Cipher;
import com.foresee.open.sdk.kit.gm.SM2;
import com.foresee.open.sdk.kit.gm.Sm2Signer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    public static Mode mode = Mode.C1C3C2;

    public static KeyPair generateKeyPair() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        return new KeyPair(ByteUtil.byteToHex(privateKey.toByteArray()), ByteUtil.byteToHex(publicKey.getEncoded(false)));
    }

    public static String generatePublicKey(String privateKey) {
        BigInteger d = new BigInteger(ByteUtil.hexToByte(privateKey));
        ECPoint ecPoint = SM2.ecc_bc_spec.getG().multiply(d);
        ECPublicKeyParameters publicParams = new ECPublicKeyParameters(ecPoint, SM2.ecc_bc_spec);
        return ByteUtil.byteToHex(publicParams.getQ().getEncoded(false));
    }

    public static String encrypt(String publicKey, String data) {
        return SM2Util.encrypt(ByteUtil.hexToByte(publicKey), data.getBytes());
    }

    public static String encrypt(byte[] publicKey, byte[] data) {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = SM2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.initEnc(sm2, userKey);
        cipher.encrypt(source);
        byte[] c3 = new byte[32];
        cipher.doFinal(c3);
        if (mode == Mode.C1C3C2) {
            return ByteUtil.byteToHex(ByteUtil.combineBytes(c1.getEncoded(false), c3, source));
        }
        return ByteUtil.byteToHex(ByteUtil.combineBytes(c1.getEncoded(false), source, c3));
    }

    public static String decrypt(String privateKey, String cipherText) {
        return new String(SM2Util.decrypt(ByteUtil.hexToByte(privateKey), ByteUtil.hexToByte(cipherText)));
    }

    public static byte[] decrypt(byte[] privateKey, byte[] cipherText) {
        byte[] c2;
        byte[] c3;
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (cipherText == null || cipherText.length == 0) {
            return null;
        }
        String data = ByteUtil.byteToHex(cipherText);
        byte[] c1Bytes = ByteUtil.hexToByte(data.substring(0, 130));
        int c2Len = cipherText.length - 97;
        if (mode == Mode.C1C3C2) {
            c3 = ByteUtil.hexToByte(data.substring(130, 194));
            c2 = ByteUtil.hexToByte(data.substring(194, 194 + 2 * c2Len));
        } else {
            c2 = ByteUtil.hexToByte(data.substring(130, 130 + 2 * c2Len));
            c3 = ByteUtil.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        }
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = SM2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.initDec(userD, c1);
        cipher.decrypt(c2);
        cipher.doFinal(c3);
        return c2;
    }

    public static String sign(String privateKey, String data) {
        return SM2Util.sign(privateKey, data, null);
    }

    public static byte[] sign(String privateKey, byte[] data) {
        return SM2Util.sign(privateKey, data, null);
    }

    public static String sign(String privateKey, String data, String userId) {
        byte[] bytes = SM2Util.sign(privateKey, data.getBytes(), userId == null ? null : userId.getBytes());
        if (bytes != null) {
            return ByteUtil.byteToHex(bytes);
        }
        return null;
    }

    public static byte[] sign(String privateKey, byte[] data, byte[] userId) {
        ECPrivateKeyParameters prikey = SM2Util.createPrivateCipherParameters(privateKey);
        return SM2Util.sign(prikey, data, userId);
    }

    public static byte[] sign(CipherParameters param, byte[] data, byte[] userId) {
        BigInteger[] sig;
        CipherParameters priKey = param;
        if (priKey instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            priKey = rParam.getParameters();
        }
        if (!(priKey instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("EC private key required for signing");
        }
        SM3Digest digest = new SM3Digest();
        byte[] e = new byte[digest.getDigestSize()];
        if (userId != null && userId.length > 0) {
            byte[] za = null;
            za = SM2Util.calculateZA((ECPrivateKeyParameters)priKey, userId);
            digest.update(za, 0, za.length);
        }
        digest.update(data, 0, data.length);
        digest.doFinal(e, 0);
        Sm2Signer signer = new Sm2Signer();
        try {
            signer.init(true, param);
            sig = signer.generateSignature(e);
        }
        catch (Exception ex) {
            throw new RuntimeException("Sign fail: " + ex.getMessage(), ex);
        }
        byte[] signature = ByteUtil.combineBytes(ByteUtil.bigIntegerToByteArray(sig[0]), ByteUtil.bigIntegerToByteArray(sig[1]));
        return signature;
    }

    public static boolean verify(String publicKey, byte[] data, byte[] sign) {
        ECPublicKeyParameters pubKey = SM2Util.createPublicCipherParameters(publicKey);
        return SM2Util.verify(pubKey, data, null, sign);
    }

    public static boolean verify(String publicKey, String data, String sign) {
        return SM2Util.verify(publicKey, data, null, sign);
    }

    public static boolean verify(String publicKey, String data, String userId, String sign) {
        return SM2Util.verify(publicKey, data.getBytes(), userId == null ? null : userId.getBytes(), ByteUtil.hexToByte(sign));
    }

    public static boolean verify(String publicKey, byte[] data, byte[] userId, byte[] sign) {
        ECPublicKeyParameters pubKey = SM2Util.createPublicCipherParameters(publicKey);
        return SM2Util.verify(pubKey, data, userId, sign);
    }

    public static boolean verify(CipherParameters pubKey, byte[] data, byte[] userId, byte[] sign) {
        SM3Digest digest = new SM3Digest();
        byte[] e = new byte[digest.getDigestSize()];
        if (userId != null && userId.length > 0) {
            byte[] za = null;
            za = SM2Util.calculateZA((ECPublicKeyParameters)pubKey, userId);
            digest.update(za, 0, za.length);
        }
        digest.update(data, 0, data.length);
        digest.doFinal(e, 0);
        ByteArrayInputStream is = new ByteArrayInputStream(sign);
        byte[] rb = new byte[sign.length / 2];
        byte[] sb = new byte[sign.length / 2];
        try {
            ((InputStream)is).read(rb, 0, sign.length / 2);
            ((InputStream)is).read(sb, 0, sign.length / 2);
        }
        catch (IOException e1) {
            return false;
        }
        BigInteger r = new BigInteger(1, rb);
        BigInteger s = new BigInteger(1, sb);
        Sm2Signer signer = new Sm2Signer();
        try {
            signer.init(false, pubKey);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Invalid public key forverify.");
        }
        return signer.verifySignature(e, r, s);
    }

    public static ECPrivateKeyParameters createPrivateCipherParameters(String privateKey) {
        BigInteger d = new BigInteger(1, ByteUtil.hexToByte(privateKey));
        return new ECPrivateKeyParameters(d, SM2.ecc_bc_spec);
    }

    public static ECPublicKeyParameters createPublicCipherParameters(String publicKey) {
        byte[] publicKeyBytes;
        byte[] encodedPublicKey = publicKeyBytes = ByteUtil.hexToByte(publicKey);
        byte[] ecP = new byte[64];
        System.arraycopy(encodedPublicKey, 1, ecP, 0, ecP.length);
        byte[] certPKX = new byte[32];
        byte[] certPKY = new byte[32];
        System.arraycopy(ecP, 0, certPKX, 0, 32);
        System.arraycopy(ecP, 32, certPKY, 0, 32);
        ECPublicKeyParameters pubKey = SM2Util.createPublicKey(certPKX, certPKY);
        return pubKey;
    }

    public static ECPublicKeyParameters createPublicKey(byte[] xH, byte[] yH) {
        BigInteger qx = new BigInteger(1, xH);
        BigInteger qy = new BigInteger(1, yH);
        ECPoint q = SM2Util.createPoint(qx, qy);
        return new ECPublicKeyParameters(q, SM2.ecc_bc_spec);
    }

    public static ECPoint createPoint(BigInteger x, BigInteger y) {
        ECCurve.Fp curve = new ECCurve.Fp(SM2.ecc_p, SM2.ecc_a, SM2.ecc_b);
        return curve.createPoint(x, y);
    }

    private static byte[] calculateZA(ECPoint G, BigInteger a, BigInteger b, ECPoint A, byte[] id) {
        SM3Digest digest = new SM3Digest();
        byte[] e = new byte[digest.getDigestSize()];
        byte[] tmp = null;
        int entla = id.length * 8;
        digest.update((byte)(entla >> 8 & 0xFF));
        digest.update((byte)(entla & 0xFF));
        digest.update(id, 0, id.length);
        tmp = ByteUtil.bigIntegerToByteArray(a);
        digest.update(tmp, 0, tmp.length);
        tmp = ByteUtil.bigIntegerToByteArray(b);
        digest.update(tmp, 0, tmp.length);
        tmp = ByteUtil.bigIntegerToByteArray(G.getAffineXCoord().toBigInteger());
        digest.update(tmp, 0, tmp.length);
        tmp = ByteUtil.bigIntegerToByteArray(G.getAffineYCoord().toBigInteger());
        digest.update(tmp, 0, tmp.length);
        tmp = ByteUtil.bigIntegerToByteArray(A.getAffineXCoord().toBigInteger());
        digest.update(tmp, 0, tmp.length);
        tmp = ByteUtil.bigIntegerToByteArray(A.getAffineYCoord().toBigInteger());
        digest.update(tmp, 0, tmp.length);
        digest.doFinal(e, 0);
        return e;
    }

    public static byte[] calculateZA(ECPrivateKeyParameters priKey, byte[] id) {
        ECPoint G = priKey.getParameters().getG();
        BigInteger a = priKey.getParameters().getCurve().getA().toBigInteger();
        BigInteger b = priKey.getParameters().getCurve().getB().toBigInteger();
        ECPoint A = ECAlgorithms.referenceMultiply(G, priKey.getD()).normalize();
        return SM2Util.calculateZA(G, a, b, A, id);
    }

    public static byte[] calculateZA(ECPublicKeyParameters pubKey, byte[] id) {
        ECPoint G = pubKey.getParameters().getG();
        BigInteger a = pubKey.getParameters().getCurve().getA().toBigInteger();
        BigInteger b = pubKey.getParameters().getCurve().getB().toBigInteger();
        ECPoint A = pubKey.getQ();
        return SM2Util.calculateZA(G, a, b, A, id);
    }

    public static class KeyPair {
        private String privateKey;
        private String publicKey;

        public KeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }
    }

    public static enum Mode {
        C1C2C3,
        C1C3C2;

    }
}

