/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit.gm;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

class SM2 {
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public static BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public static BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public static BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public static BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public static BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public static BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public static ECCurve ecc_curve = new ECCurve.Fp(ecc_p, ecc_a, ecc_b);
    public static ECPoint ecc_point_g = ecc_curve.createPoint(ecc_gx, ecc_gy);
    public static ECDomainParameters ecc_bc_spec = new ECDomainParameters(ecc_curve, ecc_point_g, ecc_n);
    public final ECKeyPairGenerator ecc_key_pair_generator;

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init(ecc_ecgenparam);
    }
}

