/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit;

import com.foresee.open.sdk.kit.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseXmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseXmlUtil.class);

    public static Map<String, Object> xmlToJson(String xmlData, Map<String, String> converterParamMap) {
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build(new ByteArrayInputStream(Base64.decode(xmlData)));
        }
        catch (JDOMException e) {
            LOGGER.error("parse xml error ", e);
            return null;
        }
        catch (IOException e) {
            LOGGER.error("parse xml error ", e);
            return null;
        }
        Element element = doc.getRootElement();
        return ParseXmlUtil.iteratorElement(element.getChildren(), converterParamMap == null ? new HashMap() : converterParamMap);
    }

    private static Map<String, Object> iteratorElement(List<Element> elements, Map<String, String> converterParamMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Element childrenElement : elements) {
            String value;
            String key = childrenElement.getName();
            if (converterParamMap.containsKey(key) && (value = converterParamMap.get(key)) != null && !"".equals(value)) {
                key = value;
            }
            if (childrenElement.getChildren().isEmpty()) {
                data.put(key, childrenElement.getValue());
                continue;
            }
            data.put(key, ParseXmlUtil.iteratorElement(childrenElement.getChildren(), converterParamMap));
        }
        return data;
    }
}

