/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;

public abstract class DigestKit {
    public static byte[] sha256(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(text.getBytes(Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++n2;
        }
        return hexString.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static byte[] decodeBase64(String str) {
        return DatatypeConverter.parseBase64Binary((String)str);
    }

    public static String md5Hex(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = digest.digest(text.getBytes(Charset.forName("UTF-8")));
            return DigestKit.toHexString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5Hex(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = digest.digest(input);
            return DigestKit.toHexString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

