/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client.ssl;

import com.foresee.open.sdk.exception.OpenApiBizException;
import java.io.File;

public class SSLConfig {
    private static boolean openHttpsRequest;
    private static File clientCertFile;
    private static String clientCertPassword;
    private static File trustStoreCertFile;
    private static String trustStoreCertPassword;
    private static String keyStoreType;
    private static String trustStoreType;
    private static String protocolType;
    private static String certificateStandard;

    static {
        keyStoreType = "PKCS12";
        trustStoreType = "JKS";
        protocolType = "SSL";
        certificateStandard = "SunX509";
    }

    public static String getClientCertPassword() {
        return clientCertPassword;
    }

    public static void setClientCertPassword(String clientCertPassword) {
        SSLConfig.clientCertPassword = clientCertPassword;
    }

    public static File getClientCertFile() {
        return clientCertFile;
    }

    public static void setClientCertFilePath(String clientCertFilePath) {
        File clientCertFile = SSLConfig.createFile(clientCertFilePath);
        if (!clientCertFile.exists()) {
            throw new OpenApiBizException("client_cert_not_exist", String.valueOf(clientCertFilePath) + "\u8bc1\u4e66\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        SSLConfig.clientCertFile = clientCertFile;
    }

    public static File getTrustStoreCertFile() {
        return trustStoreCertFile;
    }

    public static void setTrustStoreCertFilePath(String trustStoreCertFilePath) {
        File trustStoreCertFile = SSLConfig.createFile(trustStoreCertFilePath);
        if (!trustStoreCertFile.exists()) {
            throw new OpenApiBizException("trust_store_cert_not_exist", String.valueOf(trustStoreCertFilePath) + "\u8bc1\u4e66\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        SSLConfig.trustStoreCertFile = trustStoreCertFile;
    }

    public static String getTrustStoreCertPassword() {
        return trustStoreCertPassword;
    }

    public static void setTrustStoreCertPassword(String trustStoreCertPassword) {
        SSLConfig.trustStoreCertPassword = trustStoreCertPassword;
    }

    public static void setKeyStoreType(String keyStoreType) {
        SSLConfig.keyStoreType = keyStoreType;
    }

    public static String getTrustStoreType() {
        return trustStoreType;
    }

    public static void setTrustStoreType(String trustStoreType) {
        SSLConfig.trustStoreType = trustStoreType;
    }

    public static String getKeyStoreType() {
        return keyStoreType;
    }

    public static String getProtocolType() {
        return protocolType;
    }

    public static String getCertificateStandard() {
        return certificateStandard;
    }

    private static File createFile(String path) {
        File file = new File(path);
        return file;
    }

    public static boolean isOpenHttpsRequest() {
        return openHttpsRequest;
    }

    public static void setOpenHttpsRequest(boolean openHttpsRequest) {
        SSLConfig.openHttpsRequest = openHttpsRequest;
    }

    public static void setSslConfig(String clientCertFilePath, String clientCertPassword, String trustStoreCertFilePath, String trustStoreCertPassword) {
        SSLConfig.setClientCertFilePath(clientCertFilePath);
        SSLConfig.setClientCertPassword(clientCertPassword);
        SSLConfig.setTrustStoreCertFilePath(trustStoreCertFilePath);
        SSLConfig.setTrustStoreCertPassword(trustStoreCertPassword);
        SSLConfig.setOpenHttpsRequest(true);
    }

    public static void setSslConfig(String clientCertFilePath, String clientCertPassword, String trustStoreCertFilePath, String trustStoreCertPassword, String keyStoreType, String trustStoreType) {
        SSLConfig.setClientCertFilePath(clientCertFilePath);
        SSLConfig.setClientCertPassword(clientCertPassword);
        SSLConfig.setTrustStoreCertFilePath(trustStoreCertFilePath);
        SSLConfig.setTrustStoreCertPassword(trustStoreCertPassword);
        SSLConfig.setKeyStoreType(keyStoreType);
        SSLConfig.setTrustStoreType(trustStoreType);
        SSLConfig.setOpenHttpsRequest(true);
    }
}

