/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.client.OpenApiHelper;
import com.foresee.open.sdk.client.OpenApiRequest;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.sdk.client.config.RequestConfig;
import com.foresee.open.sdk.client.ssl.SSLConfig;
import com.foresee.open.sdk.client.ssl.SSLHelper;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiClientException;
import com.foresee.open.sdk.exception.OpenApiResponseException;
import com.foresee.open.sdk.json.JsonKit;
import com.foresee.open.sdk.kit.DesKit;
import com.foresee.open.sdk.kit.VersionUtil;
import com.foresee.open.sdk.kit.gm.SM4Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenHttpClient.class);
    private static final Map<String, String> debugURLs = new HashMap<String, String>();
    private String appId;
    private String encryptKey;
    private OpenApiConstants.EncryptAlgorithm encryptAlgorithm;
    private OpenApiConstants.SignAlgorithm signAlgorithm;
    private String signKey;
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private String sessionId = UUID.randomUUID().toString().replace("-", "");
    private static final String SDK_DEFAULT_VERSION = "2.2.7";
    private static final String ua = "FORESEE OPEN-SDK " + VersionUtil.getSdkVersion("2.2.7");
    private OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(180L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(20, 1L, TimeUnit.MINUTES)).retryOnConnectionFailure(true);
    private OkHttpClient client;
    private OkHttpClient downloadClient = null;

    public OpenHttpClient(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        this.appId = appId;
        this.encryptKey = encryptKey;
        this.encryptAlgorithm = encryptAlgorithm;
        this.signKey = signKey;
        this.signAlgorithm = signAlgorithm;
        if (SSLConfig.isOpenHttpsRequest()) {
            this.builder.sslSocketFactory(SSLHelper.getSSLCertifcation());
        }
        if (RequestConfig.isProxyFlag()) {
            this.builder.proxy(RequestConfig.getProxy());
        }
        if (RequestConfig.isTimeoutFlag()) {
            this.builder.connectTimeout(RequestConfig.getConnectTimeout(), TimeUnit.SECONDS);
            this.builder.readTimeout(RequestConfig.getReadTimeout(), TimeUnit.SECONDS);
            this.builder.writeTimeout(RequestConfig.getWriteTimeout(), TimeUnit.SECONDS);
        }
        this.client = this.builder.build();
    }

    public String post(OpenApiRequest openApiRequest) {
        String host;
        Object requestObject = openApiRequest.getRequestObject();
        String requestData = requestObject instanceof String ? (String)requestObject : JsonKit.toString(requestObject);
        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        if (openApiRequest.getContextType() != null) {
            JSON = MediaType.parse(openApiRequest.getContextType().getContextType());
        }
        TreeMap<String, Object> queryMap = this.genQueryMap(openApiRequest);
        String apiUrl = openApiRequest.getPath();
        String url = host = openApiRequest.getHost();
        if (!host.endsWith("/") && !apiUrl.startsWith("/")) {
            url = url.concat("/");
        }
        url = url.concat(apiUrl);
        boolean isDebug = false;
        if (debugURLs.containsKey(apiUrl)) {
            isDebug = true;
            url = debugURLs.get(apiUrl);
        }
        if (!isDebug && this.encryptKey != null) {
            if (this.signAlgorithm == OpenApiConstants.SignAlgorithm.SM2 && this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.SM4) {
                String key = openApiRequest.getEncryptionKey() != null ? openApiRequest.getEncryptionKey() : this.encryptKey;
                requestData = SM4Util.encryptDataCBC(key, requestData);
            } else if (this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.DES) {
                requestData = DesKit.encrypt(this.encryptKey, requestData);
            } else if (this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.SM4) {
                requestData = SM4Util.encryptDataCBC(this.encryptKey, requestData);
            } else {
                throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)this.encryptAlgorithm));
            }
        }
        String requestId = "\u672a\u77e5requestId";
        if (queryMap != null) {
            requestId = "" + queryMap.get("requestId");
        }
        if (this.signAlgorithm == OpenApiConstants.SignAlgorithm.SM2) {
            openApiRequest.setSignKey(this.signKey);
        }
        String queryString = OpenApiHelper.genQueryString(queryMap, openApiRequest.getSignKey(), this.signAlgorithm, requestData);
        url = url.concat(url.endsWith("?") ? "" : "?").concat(queryString);
        if (logger.isDebugEnabled()) {
            logger.debug("Request requestId: {}, url: {}, body: {}", requestId, url, requestData);
        }
        RequestBody body = RequestBody.create(JSON, requestData);
        Request.Builder builder = new Request.Builder().url(url);
        if (openApiRequest.getRequestHeaders() != null) {
            for (Map.Entry<String, Object> header : openApiRequest.getRequestHeaders().entrySet()) {
                builder.addHeader(header.getKey(), "" + header.getValue());
            }
        }
        Request request = builder.post(body).build();
        try {
            Object object = null;
            Object var16_18 = null;
            try (Response response = this.client.newCall(request).execute();){
                String encryptedRespText = response.body().string();
                if (response.code() != 200) {
                    throw new OpenApiClientException(String.valueOf(url) + " \u8c03\u7528\u63a5\u53e3\u9519\u8bef, http\u9519\u8bef\u7801" + response.code() + ",\u8bf7\u6c42requestId:" + requestId);
                }
                if ((encryptedRespText = encryptedRespText.trim()).startsWith("{")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Response requestId: {}, body: {}", (Object)requestId, (Object)encryptedRespText);
                    }
                    return encryptedRespText;
                }
                if (!isDebug && this.encryptKey != null) {
                    if (this.signAlgorithm == OpenApiConstants.SignAlgorithm.SM2 && this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.SM4) {
                        String key = openApiRequest.getEncryptionKey() != null ? openApiRequest.getEncryptionKey() : this.encryptKey;
                        encryptedRespText = SM4Util.decryptDataCBC(key, key, encryptedRespText, true);
                    } else if (this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.DES) {
                        encryptedRespText = DesKit.decryptAndDecompress(this.encryptKey, encryptedRespText);
                    } else if (this.encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.SM4) {
                        encryptedRespText = SM4Util.decryptDataCBC(this.encryptKey, this.encryptKey, encryptedRespText, true);
                    } else {
                        throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)this.encryptAlgorithm) + ",\u8bf7\u6c42requestId:" + requestId);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Response requestId: {}, body: {}", (Object)requestId, (Object)encryptedRespText);
                }
                return encryptedRespText;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            throw new OpenApiClientException("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38,\u8bf7\u6c42requestId:" + requestId, e);
        }
    }

    private TreeMap<String, Object> genQueryMap(OpenApiRequest openApiRequest) {
        String requestId = UUID.randomUUID().toString().replace("-", "");
        Map<String, ?> givenQueryMap = openApiRequest.getQueryMap();
        TreeMap<String, Object> queryMap = new TreeMap<String, Object>();
        queryMap.put("appId", this.appId);
        String sessionIdKey = "sessionId";
        String requestIdKey = "requestId";
        String timestampKey = "timestamp";
        String accessTokenKey = "accessToken";
        if (!givenQueryMap.containsKey(sessionIdKey)) {
            queryMap.put(sessionIdKey, this.sessionId);
        }
        if (!givenQueryMap.containsKey(requestIdKey)) {
            queryMap.put(requestIdKey, requestId);
        }
        if (!givenQueryMap.containsKey(timestampKey)) {
            long timestamps = System.currentTimeMillis();
            queryMap.put(timestampKey, String.valueOf(timestamps));
        }
        if (!givenQueryMap.containsKey(accessTokenKey)) {
            queryMap.put(accessTokenKey, openApiRequest.getAccessToken());
        }
        queryMap.putAll(givenQueryMap);
        return queryMap;
    }

    public <T> T execute(OpenApiRequest openApiRequest, Class<T> cls) {
        String respText = this.post(openApiRequest);
        OpenApiResponse entireResponse = JsonKit.fromJson(respText, OpenApiResponse.class);
        if (entireResponse.isFailed()) {
            throw new OpenApiResponseException("\u8bf7\u6c42\u5931\u8d25, " + entireResponse.getHead());
        }
        if (cls == Void.class) {
            return null;
        }
        return entireResponse.getBody(cls);
    }

    public String getSignKey() {
        return this.signKey;
    }

    public OpenHttpClient setSignKey(String signKey) {
        this.signKey = signKey;
        return this;
    }

    public static void addDebugURL(String path, String debugURL) {
        debugURLs.put(path, debugURL);
    }

    public static void removeDebugURL(String path) {
        debugURLs.remove(path);
    }

    public String download(String url, int timeoutMills) {
        OkHttpClient client = this.getDownloadHttpClient(timeoutMills);
        Request request = new Request.Builder().url(url).addHeader("User-Agent", ua).get().build();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Response response = client.newCall(request).execute();){
                String encryptedRespText = response.body().string();
                if (response.code() != 200) {
                    throw new OpenApiClientException(String.valueOf(url) + " \u4e0b\u8f7dAPI\u8c03\u7528\u7ed3\u679c\u9519\u8bef, http\u9519\u8bef\u7801" + response.code());
                }
                return encryptedRespText = encryptedRespText.trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new OpenApiClientException("\u4e0b\u8f7dAPI\u8c03\u7528\u7ed3\u679c\u9519\u8bef\uff1a" + url, e);
        }
    }

    private synchronized OkHttpClient getDownloadHttpClient(int timeoutMills) {
        if (this.downloadClient == null) {
            this.downloadClient = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(timeoutMills, TimeUnit.MILLISECONDS).writeTimeout(1L, TimeUnit.MINUTES).connectionPool(new ConnectionPool(20, 1L, TimeUnit.MINUTES)).retryOnConnectionFailure(true).build();
        }
        return this.downloadClient;
    }
}

