/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.client.OpenApiHelper;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiClientException;
import com.foresee.open.sdk.kit.DesKit;
import com.google.common.base.Strings;
import java.util.TreeMap;
import java.util.UUID;

public class OpenApiSecurityUtils {
    public static String getQueryStr(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String body, String accessToken) {
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        queryMap.put("appId", appId);
        String sessionIdKey = "sessionId";
        String requestIdKey = "requestId";
        String timestampKey = "timestamp";
        String accessTokenKey = "accessToken";
        queryMap.put(sessionIdKey, sessionId);
        queryMap.put(requestIdKey, requestId);
        long timestamps = System.currentTimeMillis();
        queryMap.put(timestampKey, String.valueOf(timestamps));
        if (accessToken != null && !accessToken.trim().equals("")) {
            queryMap.put(accessTokenKey, accessToken);
        }
        return OpenApiHelper.genQueryString(queryMap, signKey, signAlgorithm, body);
    }

    public static String getEncryptBody(String bodyJson, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        String encryptBody = bodyJson;
        if (encryptKey != null) {
            if (encryptAlgorithm == OpenApiConstants.EncryptAlgorithm.DES) {
                encryptBody = DesKit.encrypt(encryptKey, bodyJson);
            } else {
                throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)encryptAlgorithm));
            }
        }
        return encryptBody;
    }

    public static String decryptBody(String encryptBody, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        String decryptBody = encryptBody;
        if (Strings.isNullOrEmpty(encryptKey)) {
            return decryptBody;
        }
        if (encryptAlgorithm != OpenApiConstants.EncryptAlgorithm.DES) {
            throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)encryptAlgorithm));
        }
        decryptBody = DesKit.decryptAndDecompress(encryptKey, encryptBody);
        return decryptBody;
    }

    public static void main(String[] args) {
        OpenApiSecurityUtils.testEncry2();
    }

    public static void testDecry() {
        String decryText = "v7tCLRxSBJImsKzydsdiLNm1Ee+tZBK25uKd3xKJp6Y3u5eHsE9MzBkLrchMVYgqAB0ycRXC2Gp6M5m7BC3a7YtIr0D4StuGe14/kC41vwChx8ethApgudciDFnjTO4ztK6/Ei905Ve6rCd4mOI4m7iRlIE3yXe67oV0AbSF7qOi6aHXDHO8Ix5VMsiAQiJTOjaVu/hggCoc8KedCgf7i3n6KT4EZuA1YcYLE44ua5v/lUEpvyA6F9oHWPOIA72XVJ8l2sH3yq+H61MxB9pAD+FyCNSgTf00q7xLeh4c76uI4ptVeRaJcqR225kDFpjiFR7AF7TCHKU=";
        String encryText = OpenApiSecurityUtils.decryptBody(decryText, "Z0zj5ryktG1nI72T", OpenApiConstants.EncryptAlgorithm.DES);
        System.out.println("\u89e3\u5bc6\u540e\u62a5\u6587=" + encryText);
    }

    private static void testEncry() {
        String bodyJson = "{\"providerAppId\":\"10001003\"}";
        String queryStr = OpenApiSecurityUtils.getQueryStr("00000001", "BBpC0azQqH3PQrO6", OpenApiConstants.SignAlgorithm.SHA256, bodyJson, null);
        System.out.println("queryStr=" + queryStr);
        System.out.println("body=" + bodyJson);
    }

    private static void testEncry2() {
        String bodyJson = "{\"userId\":12333}";
        String queryStr = OpenApiSecurityUtils.getQueryStr("00000001", "4360896d5ca9005", OpenApiConstants.SignAlgorithm.MD5, bodyJson, "85b278b66703aa13bc2c732b8e767835");
        System.out.println("queryStr=" + queryStr);
        System.out.println("body=" + bodyJson);
    }
}

