/*
 * <p>Copyright Foresee Science & Technology Co.</p>
 * @author <a href="mailto:chenqiang@foresee.com.cn">chenqiang</a>
 * $Id: ResourceUtils.java 84 2009-10-23 01:26:02Z chenqiang@foresee.com.cn $
 */
package com.foresee.open.sdk.kit;

import java.io.IOException;
import java.io.InputStream;

/**
 * <p>
 * 资源工具
 * </p>
 *
 * @author <a href="mailto:chenqiang@foresee.com.cn">chenqiang</a>
 * @version $LastChangedRevision: 84 $
 */
public class ResourceUtils {

    public static String getFileContentFromClassPath(Class theClass, String fileName) throws IOException {
        return getFileContentFromClassPath(theClass, fileName, null);
    }

    public static String getFileContentFromClassPath(Class theClass, String fileName, String encoding) throws IOException {
        InputStream inputStream = theClass.getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }

        try {
            long contentLength = inputStream.available();
            byte[] bytes = new byte[(int) contentLength];
            inputStream.read(bytes);
            if (encoding != null) {
                return new String(bytes, encoding);
            }
            return new String(bytes, "UTF-8");
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (Exception e) {
                }
            }
        }
    }

    public static byte[] getFileFromClassPath(Class theClass, String fileName) throws IOException {

        InputStream inputStream = theClass.getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }

        try {
            long contentLength = inputStream.available();
            byte[] bytes = new byte[(int) contentLength];
            inputStream.read(bytes);
            return bytes;
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (Exception e) {
                }
            }
        }
    }
}
