package com.foresee.open.sdk.kit;/**
 * Copyright(c) Foresee Science & Technology Ltd.
 */


import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 。解析XML工具类
 * </pre>
 *
 * @author @foresee.com.cn
 * @version 1.00.00
 *
 * <pre>
 * 修改记录
 *    修改后版本:     修改人：  修改日期:     修改内容:
 *          </pre>
 * @date
 */


public class ParseXmlUtil {
    /**
     * 日志记录
     */
    private final static Logger LOGGER = LoggerFactory.getLogger(ParseXmlUtil.
            class);

    public static Map<String, Object> xmlToJson(String xmlData, Map<String, String> converterParamMap) {
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build(new ByteArrayInputStream(Base64.decode(xmlData)));
        } catch (JDOMException e) {
            LOGGER.error("parse xml error ", e);
            return null;
        } catch (IOException e) {
            LOGGER.error("parse xml error ", e);
            return null;
        }
        Element element = doc.getRootElement();
        return iteratorElement(element.getChildren(), converterParamMap == null ? new HashMap<String, String>() : converterParamMap);
    }

    private static Map<String, Object> iteratorElement(List<Element> elements, Map<String, String> converterParamMap) {
        Map<String, Object> data = new HashMap<>();
        for (Element childrenElement : elements) {
            String key = childrenElement.getName();
            if (converterParamMap.containsKey(key)) {
                String value = converterParamMap.get(key);
                if (value != null && !"".equals(value)) {
                    key = value;
                }
            }
            if (childrenElement.getChildren().isEmpty()) {
                data.put(key, childrenElement.getValue());
            } else {
                data.put(key, iteratorElement(childrenElement.getChildren(), converterParamMap));
            }
        }
        return data;
    }

}
