package com.foresee.open.sdk.kit;


import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.zip.InflaterInputStream;

/**
 * DesKit
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public abstract class DesKit {

    private static final int BUFFER_SIZE = 2048 ;

    public static String encrypt(String desKey, String data) {
        try {
            Cipher cipher;
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(desKey.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            cipher = Cipher.getInstance("DES");
            cipher.init(Cipher.ENCRYPT_MODE, key, sr);

            byte[] bytes = data.getBytes("UTF-8");
            String string = DigestKit.encodeBase64(cipher.doFinal(bytes));
            return string;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String desKey, String base64Data) {
        try {
            byte[] base64Bytes = DigestKit.decodeBase64(base64Data);
            Cipher cipher;
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(desKey.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            cipher = Cipher.getInstance("DES/ECB/NoPadding");
            // cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, key, sr);

            byte[] bytes = cipher.doFinal(base64Bytes);
            return new String(bytes).trim();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    
    public static String decryptAndDecompress(String desKey, String base64Data) {
        try {
            byte[] base64Bytes = DigestKit.decodeBase64(base64Data);
            Cipher cipher;
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(desKey.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            cipher = Cipher.getInstance("DES/ECB/NoPadding");
            // cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, key, sr);

            byte[] bytes = cipher.doFinal(base64Bytes);
            return new String(decompress(bytes));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] decompress(byte[] encdata) throws IOException {
        if (encdata == null) {
            return null;
        }

        InputStream inputStream = null;
        InflaterInputStream inflaterInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            inputStream = new ByteArrayInputStream(encdata);
            inflaterInputStream = new InflaterInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();

            int count;
            byte[] data = new byte[BUFFER_SIZE];
            while ((count = inflaterInputStream.read(data, 0, BUFFER_SIZE)) != -1) {
                byteArrayOutputStream.write(data, 0, count);
            }

            return byteArrayOutputStream.toByteArray();
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inflaterInputStream != null) {
                inflaterInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }
}
