/**
 * Copyright(c) Foresee Science & Technology Ltd.
 */
package com.foresee.open.sdk.constant;

/**
 * <pre>
 * 常量定义
 * </pre>
 *
 * @author chenqiang@foresee.com.cn
 * @version 1.00.00
 * @date 2018年7月3日
 */

public interface OpenApiConstants {

    enum SignAlgorithm {
        NONE, MD5, SHA256, SM3, SM2,
        ;
    }

    enum EncryptAlgorithm {
        NONE, DES, SM4;
    }

    SignAlgorithm DEFAULT_SIGN_ALGORITHM = SignAlgorithm.SHA256;

    EncryptAlgorithm DEFAULT_ENCRYPT_ALGORITHM = EncryptAlgorithm.DES;


    enum RequestContextType {
        JSON("application/json; charset=utf-8"),
        XML("application/xml; charset=utf-8");

        private String contextType;

        private RequestContextType(String contextType) {
            this.contextType = contextType;
        }

        public String getContextType() {
            return contextType;
        }
    }

    /**
     * 默认请求类型
     */
    RequestContextType DEFAULT_CONTEXT_TYPE = RequestContextType.JSON;

    /**
     * requestId参数
     */
    public static final String P_REQUEST_ID = "requestId";


    /**
     * 内容字段
     */
    public static final String P_CONTENT = "content";

    /**
     * 空请求参数
     */
    public static final String BODY_IS_NULL = "{}";
}
