package com.foresee.open.sdk.client.ssl;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLHelper {
    public static SSLSocketFactory getSSLCertifcation() {
        SSLSocketFactory sslSocketFactory = null;
        try {
            //初始化密钥库
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SSLConfig.getCertificateStandard());
            //服务器端需要验证的客户端证书，其实就是客户端的keystore
            KeyStore keyStore = getKeyStore(SSLConfig.getClientCertFile(), SSLConfig.getClientCertPassword(), SSLConfig.getKeyStoreType());
            keyManagerFactory.init(keyStore, SSLConfig.getClientCertPassword().toCharArray());

            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SSLConfig.getCertificateStandard());
            // 客户端信任的服务器端证书
            KeyStore trustStore = getKeyStore(SSLConfig.getTrustStoreCertFile(), SSLConfig.getTrustStoreCertPassword(), "JKS");
            trustManagerFactory.init(trustStore);

            //初始化SSLContext
            SSLContext sslContext = SSLContext.getInstance(SSLConfig.getProtocolType());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = sslContext.getSocketFactory();

        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sslSocketFactory;
    }

    /**
     * 创建KeyStore
     *
     * @param keyStoreFile:证书文件
     * @param password:密码
     * @param type:类型
     * @return
     */
    private static KeyStore getKeyStore(File keyStoreFile, String password, String type) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        //读取证书
        InputStream is = new FileInputStream(keyStoreFile);
        // 服务器端需要验证的客户端证书，其实就是客户端的keystore
        KeyStore keyStore = KeyStore.getInstance(type);
        //加载证书
        keyStore.load(is, password.toCharArray());
        is.close();
        return keyStore;
    }
}