package com.foresee.open.sdk.client.ssl;

import com.foresee.open.sdk.exception.OpenApiBizException;

import java.io.File;

public class SSLConfig {
    private static boolean openHttpsRequest;
    /**
     * 客户端证书路径
     * client.p12
     */
    private static File clientCertFile;


    /**
     * 客户端证书密码
     */
    private static String clientCertPassword;

    /**
     * 信任证书路径
     * opensdk.truststore
     */
    private static File trustStoreCertFile;

    /**
     * 信任证书密码
     */
    private static String trustStoreCertPassword;


    /**
     * key证书类型
     */
    private static String keyStoreType = "PKCS12";


    private static String trustStoreType = "JKS";

    /**
     * 协议证书类型
     */
    private static String protocolType = "SSL";


    private static String certificateStandard = "SunX509";


    public static String getClientCertPassword() {
        return clientCertPassword;
    }

    public static void setClientCertPassword(String clientCertPassword) {
        SSLConfig.clientCertPassword = clientCertPassword;
    }

    public static File getClientCertFile() {
        return clientCertFile;
    }

    public static void setClientCertFilePath(String clientCertFilePath) {
        File clientCertFile = createFile(clientCertFilePath);
        if (!clientCertFile.exists()) {
            throw new OpenApiBizException("client_cert_not_exist", clientCertFilePath + "证书不存在,请检查");
        }
        SSLConfig.clientCertFile = clientCertFile;
    }

    public static File getTrustStoreCertFile() {
        return trustStoreCertFile;
    }

    public static void setTrustStoreCertFilePath(String trustStoreCertFilePath) {
        File trustStoreCertFile = createFile(trustStoreCertFilePath);
        if (!trustStoreCertFile.exists()) {
            throw new OpenApiBizException("trust_store_cert_not_exist", trustStoreCertFilePath + "证书不存在,请检查");
        }
        SSLConfig.trustStoreCertFile = trustStoreCertFile;
    }

    public static String getTrustStoreCertPassword() {
        return trustStoreCertPassword;
    }

    public static void setTrustStoreCertPassword(String trustStoreCertPassword) {
        SSLConfig.trustStoreCertPassword = trustStoreCertPassword;
    }

    public static void setKeyStoreType(String keyStoreType) {
        SSLConfig.keyStoreType = keyStoreType;
    }

    public static String getTrustStoreType() {
        return trustStoreType;
    }

    public static void setTrustStoreType(String trustStoreType) {
        SSLConfig.trustStoreType = trustStoreType;
    }

    public static String getKeyStoreType() {
        return keyStoreType;
    }

    public static String getProtocolType() {
        return protocolType;
    }

    public static String getCertificateStandard() {
        return certificateStandard;
    }

    private static File createFile(String path) {
        File file = new File(path);
        return file;
    }

    public static boolean isOpenHttpsRequest() {
        return openHttpsRequest;
    }

    public static void setOpenHttpsRequest(boolean openHttpsRequest) {
        SSLConfig.openHttpsRequest = openHttpsRequest;
    }

    /**
     * SSL请求配置信息
     *
     * @param clientCertFilePath:客户端证书路径
     * @param clientCertPassword：客户端证书密码
     * @param trustStoreCertFilePath：信任证书路径
     * @param trustStoreCertPassword：信任证书密码
     */
    public static void setSslConfig(String clientCertFilePath, String clientCertPassword, String trustStoreCertFilePath, String trustStoreCertPassword) {
        SSLConfig.setClientCertFilePath(clientCertFilePath);
        SSLConfig.setClientCertPassword(clientCertPassword);
        SSLConfig.setTrustStoreCertFilePath(trustStoreCertFilePath);
        SSLConfig.setTrustStoreCertPassword(trustStoreCertPassword);
        SSLConfig.setOpenHttpsRequest(true);
    }

    /**
     * SSL请求配置信息
     *
     * @param clientCertFilePath:客户端证书路径
     * @param clientCertPassword：客户端证书密码
     * @param trustStoreCertFilePath：信任证书路径
     * @param trustStoreCertPassword：信任证书密码
     * @param keyStoreType                  ：客户端证书密钥类型
     * @param trustStoreType                :信任证书密钥类型
     */
    public static void setSslConfig(String clientCertFilePath, String clientCertPassword, String trustStoreCertFilePath, String trustStoreCertPassword, String keyStoreType, String trustStoreType) {
        SSLConfig.setClientCertFilePath(clientCertFilePath);
        SSLConfig.setClientCertPassword(clientCertPassword);
        SSLConfig.setTrustStoreCertFilePath(trustStoreCertFilePath);
        SSLConfig.setTrustStoreCertPassword(trustStoreCertPassword);
        SSLConfig.setKeyStoreType(keyStoreType);
        SSLConfig.setTrustStoreType(trustStoreType);
        SSLConfig.setOpenHttpsRequest(true);
    }
}

