/**
 * Copyright(c) Foresee Science & Technology Ltd.
 */
package com.foresee.open.sdk.client;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.json.JsonKit;

/**
 * <pre>
 * 压测工具类
 * </pre>
 *
 * @author chenqiang@foresee.com.cn
 * @date 2018年9月18日
 * @version 1.00.00
 */

public class PressKit {

    public static String gen(String appId, String signKey, String body, String accessToken) {
        TreeMap queryMap = new TreeMap();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        queryMap.put("appId", appId);

        String sessionIdKey = "sessionId";
        String requestIdKey = "requestId";
        String timestampKey = "timestamp";
        String accessTokenKey = "accessToken";

        queryMap.put(sessionIdKey, sessionId);
        queryMap.put(requestIdKey, requestId);
        long timestamps = System.currentTimeMillis();
        queryMap.put(timestampKey, String.valueOf(timestamps));
        if ((accessToken != null) && (!accessToken.trim().equals(""))) {
            queryMap.put(accessTokenKey, accessToken);
        }

        String queryString = OpenApiHelper.genQueryString(queryMap, signKey, OpenApiConstants.DEFAULT_SIGN_ALGORITHM, body);
        return queryString;
    }

    public static void main(String[] args) {
        Map map = new HashMap();
        map.put("loginName", "admin");
        map.put("password", "111111");

        String body = JsonKit.toString(map);

        String queryString = gen("000106", "1", body, null);
        System.out.println(queryString);
    }
}
