package com.foresee.open.sdk.client;

import java.util.Map;
import com.foresee.open.sdk.json.JsonKit;

/**
 * EntireResponse
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public class OpenApiResponse<T> {

    private T                   body;

    private Head                head;

    private Map<String, Object> extMap;


    public Head getHead() {
        return head;
    }

    public OpenApiResponse<T> setHead(Head head) {
        this.head = head;
        return this;
    }


    public static class Head {

        /**
         * 错误代码
         */
        private String errorCode;

        /**
         * 错误信息
         */
        private String errorMsg;

        /**
         * 请求ID
         */
        private String requestId;

        /**
         * 时间戳
         */
        private long   timestamp;

        /**
         * 服务响应时间
         */
        private long   time;

        /**
         * 网关响应时间
         */
        private long   gtime;

        /**
         * 网关代理响应时间
         */
        private long   ptime;

        /**
         * 流水号
         */
        private String errorNo;

        /**
         * 签名信息
         */
        private String sign;


        public String getErrorCode() {
            return errorCode;
        }

        public Head setErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public Head setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public String getRequestId() {
            return requestId;
        }

        public Head setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public long getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTime() {
            return time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getGtime() {
            return gtime;
        }

        public void setGtime(long gtime) {
            this.gtime = gtime;
        }

        public long getPtime() {
            return ptime;
        }

        public void setPtime(long ptime) {
            this.ptime = ptime;
        }

        public String getErrorNo() {
            return errorNo;
        }

        public void setErrorNo(String errorNo) {
            this.errorNo = errorNo;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        @Override
        public String toString() {
            return "Head{" + "errorCode='" + errorCode + '\'' + ", errorMsg='" + errorMsg + '\'' + ", requestId='" + requestId + '\''
                    + '}';
        }
    }


    public boolean isSuccess() {
        return "0".equals(this.head.errorCode);
    }

    public boolean isFailed() {
        return !isSuccess();
    }

    public T getBody() {
        return body;
    }

    public T getBody(Class<T> cls) {
        if (this.body == null) {
            return null;
        }
        String json = JsonKit.toString(this.body);
        return JsonKit.fromJson(json, cls);
    }

    public OpenApiResponse<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public Map<String, Object> getExtMap() {
        return extMap;
    }

    public void setExtMap(Map<String, Object> extMap) {
        this.extMap = extMap;
    }

}
