package com.foresee.open.sdk.auth.vo;

import java.util.Date;

/**
 * AppUserTokenIn
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public class AccessToken {

    /**
     * 用户级访问令牌
     */
    private String accessToken;

    /**
     * 随机密钥
     */
    private String randomKey;

    /**
     * 超时时间（秒）
     */
    private Integer expireTimes;

    /**
     * 提供方的域名， 如https://epj.foresee.com.cn
     */
    private String providerAppURL;


    private transient Date expireDate;

    public String getRandomKey() {
        return randomKey;
    }

    public AccessToken setRandomKey(String randomKey) {
        this.randomKey = randomKey;
        return this;
    }

    public Integer getExpireTimes() {
        return expireTimes;
    }

    public AccessToken setExpireTimes(Integer expireTimes) {
        this.expireTimes = expireTimes;
        return this;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public AccessToken setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getProviderAppURL() {
        return providerAppURL;
    }

    public AccessToken setProviderAppURL(String providerAppURL) {
        this.providerAppURL = providerAppURL;
        return this;
    }

    public AccessToken expireDate(Date expireDate) {
        this.expireDate = expireDate;
        return this;
    }

    public Date expireDate() {
        return this.expireDate;
    }
}
