package com.foresee.open.sdk.auth;

import com.foresee.open.sdk.api.ApiParam;
import com.foresee.open.sdk.api.ApiResource;
import com.foresee.open.sdk.api.AuthBaseOpenApi;
import com.foresee.open.sdk.auth.vo.AccessToken;
import com.foresee.open.sdk.auth.vo.AccessTokenValidateResult;

/**
 * AccessTokenApi
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
@ApiResource("accessToken")
public interface InternalAccessTokenApi extends AuthBaseOpenApi {

    AccessToken getByUserToken(
            @ApiParam("userToken") String userToken,
            @ApiParam("providerAppId") String providerAppId
    );

    AccessToken getByApp(@ApiParam(value = "providerAppId") String providerAppId);
    
    AccessTokenValidateResult validate(@ApiParam(value = "accessToken") String accessToken);
}
