package com.foresee.open.sdk.auth;

import com.foresee.open.sdk.client.config.RequestConfig;

import java.net.Proxy;

/**
 * AuthHost
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
public class GatewayConfig {

    /**
     * 是否跳过网关,只用于内网测试开发
     */
    private static boolean skipGateway = false;

    /**
     * 网关地址 (当skipGateway为true时, 代表服务的地址)
     */
    private static String address;

    /**
     * 忽略提供方URL，直接使用网关的URL请求API
     */
    private static boolean ignoreProviderURL = false;

    /**
     * 总重试次数
     */
    private static int retryTotalCount = 10;

    public static String getAddress() {
        return address;
    }

    public static void setAddress(String address) {
        GatewayConfig.address = address;
    }

    public static boolean isSkipGateway() {
        return skipGateway;
    }

    public static void setSkipGateway(boolean skipGateway) {
        GatewayConfig.skipGateway = skipGateway;
    }

    public static boolean isIgnoreProviderURL() {
        return ignoreProviderURL;
    }

    public static void setIgnoreProviderURL(boolean ignoreProviderURL) {
        GatewayConfig.ignoreProviderURL = ignoreProviderURL;
    }

    public static void setProxy(Proxy proxy) {
        RequestConfig.setProxy(proxy);
    }

    public static void setConnectTimeout(long connectTimeout) {
        RequestConfig.setConnectTimeout(connectTimeout);
    }

    public static void setReadTimeout(long readTimeout) {
        RequestConfig.setReadTimeout(readTimeout);
    }

    public static void setWriteTimeout(long writeTimeout) {
        RequestConfig.setWriteTimeout(writeTimeout);
    }

    public static int getRetryTotalCount() {
        return retryTotalCount;
    }

    public static void setRetryTotalCount(int retryTotalCount) {
        GatewayConfig.retryTotalCount = retryTotalCount;
    }
}
