package com.foresee.open.sdk.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * OpenApi, 定义url, 接口级别(公开/用户/应用)
 *
 * @author chenwenlong@foresee.com.cn
 * @version 1.0
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface OpenApiService {

    /**
     * 应用服务名称
     * @return
     */
    String name();

    /**
     * 应用ID
     * @return
     */
    String appId();
}
