/**
 * Copyright(c) Foresee Science & Technology Ltd.
 */
package com.foresee.open.sdk.api;

import com.foresee.open.sdk.client.OpenApiResponse;

/**
 * <pre>
 * 异步调用配置
 * </pre>
 *
 * @author chenqiang@foresee.com.cn
 * @date 2018年9月6日
 * @version 1.00.00
 */

public class ExtMapConfig {

    private String            contentEncoding;

    private AsynchQueryConfig asynchQuery;
    
    private String downloadUrl;

    private OpenApiResponse   response;


    public OpenApiResponse getResponse() {
        return response;
    }

    public void setResponse(OpenApiResponse response) {
        this.response = response;
    }

    public String getContentEncoding() {
        return contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public AsynchQueryConfig getAsynchQuery() {
        return asynchQuery;
    }

    public void setAsynchQuery(AsynchQueryConfig asynchQueryConfig) {
        this.asynchQuery = asynchQueryConfig;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }




    public static class AsynchQueryConfig {

        /**
         * 等待时间
         */
        private int    waitTime;

        /**
         * 接口路径
         */
        private String apiUrl;

        /**
         * 请求报文
         */
        private String requestBody;


        public int getWaitTime() {
            return waitTime;
        }

        public void setWaitTime(int waitTime) {
            this.waitTime = waitTime;
        }

        public String getApiUrl() {
            return apiUrl;
        }

        public void setApiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
        }

        public String getRequestBody() {
            return requestBody;
        }

        public void setRequestBody(String requestBody) {
            this.requestBody = requestBody;
        }
    }
}
