/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit.gm;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;

class Sm2Signer {
    private Boolean isSign;
    private ECKeyParameters key;
    private SecureRandom random;

    Sm2Signer() {
    }

    public String getAlgorithmName() {
        return "Sm2Signer";
    }

    public void init(boolean isSign, CipherParameters parameters) throws InvalidKeyException {
        this.isSign = isSign;
        if (isSign) {
            if (parameters instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)parameters;
                this.random = rParam.getRandom();
                parameters = rParam.getParameters();
            } else {
                this.random = new SecureRandom();
            }
            if (!(parameters instanceof ECPrivateKeyParameters)) {
                throw new InvalidKeyException("EC private key required for signing");
            }
            this.key = (ECPrivateKeyParameters)parameters;
        } else {
            if (!(parameters instanceof ECPublicKeyParameters)) {
                throw new InvalidKeyException("EC public key required for verification");
            }
            this.key = (ECPublicKeyParameters)parameters;
        }
    }

    public BigInteger[] generateSignature(byte[] message) throws Exception {
        BigInteger tmp2;
        BigInteger dA;
        BigInteger tmp;
        BigInteger k;
        AsymmetricCipherKeyPair tempPair;
        ECPublicKeyParameters V;
        BigInteger Vx;
        if (!this.isSign.booleanValue()) {
            throw new Exception("not initialised for signing");
        }
        BigInteger n = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, message);
        int eBitLength = e.bitLength();
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)this.key;
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECKeyPairGenerator keyGen = new ECKeyPairGenerator();
            keyGen.init(new ECKeyGenerationParameters(privKey.getParameters(), this.random));
            tempPair = keyGen.generateKeyPair();
            k = ((ECPrivateKeyParameters)tempPair.getPrivate()).getD();
        } while ((r = (Vx = (V = (ECPublicKeyParameters)tempPair.getPublic()).getQ().getAffineXCoord().toBigInteger()).add(e).mod(n)).signum() == 0 || r.equals(BigInteger.ZERO) || r.add(k).equals(n) || (s = (tmp = (dA = privKey.getD()).add(BigInteger.ONE).modInverse(n)).multiply(tmp2 = k.subtract(r.multiply(dA))).mod(n)).equals(BigInteger.ZERO));
        return new BigInteger[]{r, s};
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint W;
        if (this.isSign.booleanValue()) {
            throw new RuntimeException("Not initialised for verifying");
        }
        ECPublicKeyParameters pubKey = (ECPublicKeyParameters)this.key;
        BigInteger n = pubKey.getParameters().getN();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, message);
        int eBitLength = e.bitLength();
        if (eBitLength > nBitLength) {
            throw new DataLengthException("Input too large for ECNR key.");
        }
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(n);
        if (t.compareTo(BigInteger.ZERO) == 0) {
            return false;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s, W = pubKey.getQ(), t).normalize();
        if (P.isInfinity()) {
            return false;
        }
        BigInteger x = P.getAffineXCoord().toBigInteger();
        BigInteger R = e.add(x).mod(n);
        return R.equals(r);
    }
}

