/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit.gm;

import com.foresee.open.sdk.kit.gm.ByteUtil;
import com.foresee.open.sdk.kit.gm.GlobalBouncyCastleProvider;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public final class SM3Util {
    private static final String ALGORITHM_NAME = "SM3";

    public static String hash(String source) {
        return new Digester(ALGORITHM_NAME).digestHex(source);
    }

    private static class Digester
    implements Serializable {
        private static final long serialVersionUID = -796343432069033377L;
        private MessageDigest digest;

        public Digester(String algorithm) {
            this(algorithm, null);
        }

        public Digester(String algorithm, Provider provider) {
            this.init(algorithm, provider);
        }

        private static MessageDigest createMessageDigest(String algorithm) {
            MessageDigest messageDigest;
            Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
            try {
                messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return messageDigest;
        }

        public Digester init(String algorithm, Provider provider) {
            if (provider == null) {
                this.digest = Digester.createMessageDigest(algorithm);
            } else {
                try {
                    this.digest = MessageDigest.getInstance(algorithm, provider);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public byte[] digest(String data, Charset charset) {
            return this.digest(Digester.bytes(data, charset));
        }

        public String digestHex(String data, Charset charset) {
            return ByteUtil.encodeHexString(this.digest(data, charset));
        }

        public String digestHex(String data) {
            return this.digestHex(data, StandardCharsets.UTF_8);
        }

        public byte[] digest(byte[] data) {
            return this.doDigest(new byte[][]{data});
        }

        private byte[] doDigest(byte[] ... datas) {
            for (byte[] data : datas) {
                if (null == data) continue;
                this.digest.update(data);
            }
            return this.digest.digest();
        }

        private static byte[] bytes(CharSequence str, Charset charset) {
            if (str == null) {
                return null;
            }
            if (charset == null) {
                return str.toString().getBytes();
            }
            return str.toString().getBytes(charset);
        }
    }
}

