/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.constant;

public interface OpenApiConstants {
    public static final SignAlgorithm DEFAULT_SIGN_ALGORITHM = SignAlgorithm.SHA256;
    public static final EncryptAlgorithm DEFAULT_ENCRYPT_ALGORITHM = EncryptAlgorithm.DES;
    public static final RequestContextType DEFAULT_CONTEXT_TYPE = RequestContextType.JSON;
    public static final String P_REQUEST_ID = "requestId";
    public static final String P_CONTENT = "content";
    public static final String BODY_IS_NULL = "{}";

    public static enum RequestContextType {
        JSON("application/json; charset=utf-8"),
        XML("application/xml; charset=utf-8");

        private String contextType;

        private RequestContextType(String contextType) {
            this.contextType = contextType;
        }

        public String getContextType() {
            return this.contextType;
        }
    }

    public static enum EncryptAlgorithm {
        NONE("NONE"),
        DES("DES"),
        SM4("SM4"),
        SM2("SM2");

        private String code;

        private EncryptAlgorithm(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static EncryptAlgorithm getEncryptAlgorithmByCode(String code) {
            EncryptAlgorithm[] encryptAlgorithms;
            if (code == null) {
                return NONE;
            }
            for (EncryptAlgorithm encryptAlgorithm : encryptAlgorithms = EncryptAlgorithm.values()) {
                if (!code.equals(encryptAlgorithm.getCode())) continue;
                return encryptAlgorithm;
            }
            return null;
        }
    }

    public static enum SignAlgorithm {
        NONE("NONE"),
        MD5("MD5"),
        SHA256("SHA-256"),
        SM3("SM3"),
        SM2("SM2");

        private String code;

        private SignAlgorithm(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static SignAlgorithm getSignAlgorithmByCode(String code) {
            SignAlgorithm[] signAlgorithms;
            if (code == null) {
                return NONE;
            }
            for (SignAlgorithm signAlgorithm : signAlgorithms = SignAlgorithm.values()) {
                if (!code.equals(signAlgorithm.getCode())) continue;
                return signAlgorithm;
            }
            return null;
        }
    }
}

