/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.constant.OpenApiConstants;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class OpenApiRequest {
    private String host;
    private String path;
    private Map<String, ?> queryMap;
    private String accessToken;
    private Object requestObject;
    private String signKey;
    private String encryptionKey;
    private OpenApiConstants.RequestContextType contextType = OpenApiConstants.DEFAULT_CONTEXT_TYPE;
    private Map<String, Object> requestHeaders = null;
    private static final String ua = "FORESEE OPEN-SDK 2.2.3";

    public OpenApiRequest(String path) {
        this.path = path;
        this.requestHeaders = new TreeMap<String, Object>();
        this.requestHeaders.put("User-Agent", ua);
    }

    public String getPath() {
        return this.path;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Object getRequestObject() {
        return this.requestObject == null ? "{}" : this.requestObject;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public OpenApiRequest setSignKey(String signKey) {
        this.signKey = signKey;
        return this;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public OpenApiRequest setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public OpenApiRequest setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public OpenApiRequest setRequestObject(Object requestObject) {
        this.requestObject = requestObject;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public OpenApiRequest setHost(String host) {
        this.host = host;
        return this;
    }

    public Map<String, ?> getQueryMap() {
        return this.queryMap != null ? this.queryMap : Collections.emptyMap();
    }

    public OpenApiRequest setQueryMap(Map<String, ?> queryMap) {
        this.queryMap = queryMap;
        return this;
    }

    public OpenApiRequest setContextType(OpenApiConstants.RequestContextType contextType) {
        this.contextType = contextType;
        return this;
    }

    public OpenApiConstants.RequestContextType getContextType() {
        return this.contextType;
    }

    public Map<String, Object> getRequestHeaders() {
        return this.requestHeaders;
    }
}

