/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.api.AccessTokenHelper;
import com.foresee.open.sdk.api.ExtMapConfig;
import com.foresee.open.sdk.auth.GatewayConfig;
import com.foresee.open.sdk.auth.vo.AccessToken;
import com.foresee.open.sdk.client.OpenApiFactory;
import com.foresee.open.sdk.client.OpenApiHelper;
import com.foresee.open.sdk.client.OpenApiRequest;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.sdk.client.OpenHttpClient;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiResponseException;
import com.foresee.open.sdk.json.JsonKit;
import com.foresee.open.sdk.kit.DesKit;
import com.foresee.open.sdk.kit.ZipUtil;
import com.google.common.base.Strings;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiClient.class);
    int asynchQueryTimeout = 1800000;
    private OpenHttpClient openHttpClient;
    private OpenApiFactory openApiFactory;
    private boolean enabledExtHandling = true;
    private AtomicInteger retryCount = new AtomicInteger(1);

    public OpenApiClient(String appId, String signKey) {
        this.openApiFactory = new OpenApiFactory(appId, signKey);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, Proxy proxy) {
        GatewayConfig.setProxy(proxy);
        this.openApiFactory = new OpenApiFactory(appId, signKey);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, String encryptKey) {
        this.openApiFactory = new OpenApiFactory(appId, signKey, OpenApiConstants.DEFAULT_SIGN_ALGORITHM, encryptKey, OpenApiConstants.DEFAULT_ENCRYPT_ALGORITHM);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm) {
        this.openApiFactory = new OpenApiFactory(appId, signKey, signAlgorithm, null, OpenApiConstants.DEFAULT_ENCRYPT_ALGORITHM);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public OpenApiClient(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        this.openApiFactory = new OpenApiFactory(appId, signKey, signAlgorithm, encryptKey, encryptAlgorithm);
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    protected OpenApiClient(OpenApiFactory openApiFactory) {
        this.openApiFactory = openApiFactory;
        this.openHttpClient = this.openApiFactory.getOpenHttpClient();
    }

    public String requestPublic(String url, Object object) {
        String body = this.toJson(object);
        return this.requestPublic(url, body);
    }

    public String toJson(Object object) {
        String body = object instanceof String ? (String)object : JsonKit.toString(object);
        return body;
    }

    public String requestPublic(String url, String body) {
        return this.requestPublic(url, body, null);
    }

    public String requestPublic(String url, String body, Map<String, Object> requestHeaderMap) {
        OpenApiRequest openApiRequest = this.urlToApiRequest(url).setRequestObject(body).setSignKey(this.openHttpClient.getSignKey());
        this.setRequestHeaders(openApiRequest, requestHeaderMap);
        return this.openHttpClient.post(openApiRequest);
    }

    public String requestApp(String url, String body, String providerAppId) {
        return this.requestApp(url, body, providerAppId, OpenApiConstants.RequestContextType.JSON, null);
    }

    public String requestApp(String url, String body, String providerAppId, Map<String, Object> requestHeaderMap) {
        return this.requestApp(url, body, providerAppId, OpenApiConstants.RequestContextType.JSON, requestHeaderMap);
    }

    public String requestApp(String url, Object object, String providerAppId) {
        String body = this.toJson(object);
        return this.requestApp(url, body, providerAppId, OpenApiConstants.RequestContextType.JSON, null);
    }

    public String requestApp(String url, String body, String providerAppId, OpenApiConstants.RequestContextType requestContextType, Map<String, Object> requestHeaderMap) {
        ExtMapConfig config;
        AccessToken accessToken;
        String responseText;
        if (Strings.isNullOrEmpty(this.openApiFactory.getGatewayAddress())) {
            OpenApiRequest openApiRequest = this.urlToApiRequest(url);
            this.openApiFactory.setGatewayAddress(openApiRequest.getHost());
        }
        if (this.isAccessTokenInvalid(url, responseText = this.requestByAccessToken(url, body, accessToken = AccessTokenHelper.getAppAccessToken(this.openApiFactory, providerAppId), requestContextType, requestHeaderMap))) {
            int maxRetryCount = GatewayConfig.getRetryTotalCount();
            if (this.isMaxRetryCount(maxRetryCount)) {
                logger.error("call[{}] get access token api failure retry count configuration maximum reached [{}]", (Object)url, (Object)maxRetryCount);
                throw new OpenApiResponseException("100100000003", "\u83b7\u53d6AccessToken\u5931\u8d25\u91cd\u8bd5\u6b21\u6570\u5df2\u8fbe\u914d\u7f6e\u6700\u5927\u503c", null);
            }
            return this.requestApp(url, body, providerAppId, requestContextType, requestHeaderMap);
        }
        this.restRetryCount();
        if (!this.enabledExtHandling) {
            return responseText;
        }
        long startTime = System.currentTimeMillis();
        while (true) {
            if ((config = this.parseExtMapConfig(responseText)) == null) {
                return responseText;
            }
            if (config.getDownloadUrl() != null) {
                String downloadUrl = config.getDownloadUrl();
                if (!downloadUrl.startsWith("http")) {
                    downloadUrl = DesKit.decrypt("04810679", config.getDownloadUrl());
                }
                logger.info("Downloading from file: {}", (Object)downloadUrl);
                long time = System.currentTimeMillis();
                responseText = this.openHttpClient.download(downloadUrl, this.asynchQueryTimeout);
                time = System.currentTimeMillis() - time;
                int fileSize = responseText == null ? 0 : responseText.length();
                logger.info("Download finished: {}, use time(ms): {}, file size: {}.", downloadUrl, time, fileSize);
                if (config.getContentEncoding() != null) {
                    try {
                        String decompressResponseBody = ZipUtil.decompress(responseText, true);
                        config.getResponse().setBody(decompressResponseBody);
                        responseText = JsonKit.toString(config.getResponse());
                    }
                    catch (Exception e) {
                        throw new OpenApiResponseException("100100000006", "\u89e3\u538b\u7f29\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage(), null);
                    }
                }
                return responseText;
            }
            if (config.getAsynchQuery() == null) break;
            if (config.getAsynchQuery().getWaitTime() > 0) {
                try {
                    logger.info("Waiting {} seconds for next asynchronous result: {}", (Object)config.getAsynchQuery().getWaitTime(), (Object)JsonKit.toString(config.getAsynchQuery()));
                    TimeUnit.SECONDS.sleep(config.getAsynchQuery().getWaitTime());
                }
                catch (InterruptedException e) {
                    throw new OpenApiResponseException("100100000001", "\u7b49\u5f85\u5f02\u6b65\u67e5\u8be2\u9519\u8bef\uff0c\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff1a" + e.getMessage(), null);
                }
            }
            if (System.currentTimeMillis() - startTime > (long)this.asynchQueryTimeout) {
                throw new OpenApiResponseException("100100000002", "\u7b49\u5f85\u5f02\u6b65\u67e5\u8be2\u8d85\u65f6\uff0c\u603b\u7b49\u5f85\u65f6\u957f(\u79d2)\uff1a" + String.valueOf((System.currentTimeMillis() - startTime) / 1000L), null);
            }
            url = config.getAsynchQuery().getApiUrl();
            body = config.getAsynchQuery().getRequestBody();
            logger.info("Invoking for asynchronous result: {}", (Object)JsonKit.toString(config.getAsynchQuery()));
            responseText = this.requestByAccessToken(url, body, accessToken, OpenApiConstants.DEFAULT_CONTEXT_TYPE, requestHeaderMap);
        }
        if (config.getContentEncoding() != null && config.getResponse().getBody() instanceof String) {
            try {
                logger.info("Unzipping data: {}", (Object)config.getResponse().getBody().toString());
                String decompressResponseBody = ZipUtil.decompress((String)config.getResponse().getBody(), true);
                config.getResponse().setBody(decompressResponseBody);
                responseText = JsonKit.toString(config.getResponse());
                logger.info("Unzipped data: {}", (Object)decompressResponseBody);
            }
            catch (Exception e) {
                throw new OpenApiResponseException("100100000003", "\u89e3\u538b\u7f29\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage(), null);
            }
        }
        return responseText;
    }

    private boolean isAccessTokenInvalid(String url, String responseText) {
        if (responseText == null || !responseText.contains("100100000030")) {
            return false;
        }
        try {
            OpenApiResponse response = JsonKit.fromJson(responseText, OpenApiResponse.class);
            if (response == null) {
                return false;
            }
            if ("100100000030".equals(response.getHead().getErrorCode())) {
                logger.error("request url:[{}] access token invalid, retry the request count:[{}]", (Object)url, (Object)this.retryCount.intValue());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String requestXmlApp(String url, String body, String providerAppId) {
        return this.requestXmlApp(url, body, providerAppId, null);
    }

    public String requestXmlApp(String url, String body, String providerAppId, Map<String, Object> requestHeaderMap) {
        return this.requestApp(url, body, providerAppId, OpenApiConstants.RequestContextType.XML, requestHeaderMap);
    }

    protected String requestByAccessToken(String url, String body, AccessToken accessToken, OpenApiConstants.RequestContextType requestContextType) {
        return this.requestByAccessToken(url, body, accessToken, requestContextType, null);
    }

    protected String requestByAccessToken(String url, String body, AccessToken accessToken, OpenApiConstants.RequestContextType requestContextType, Map<String, Object> requestHeaderMap) {
        OpenApiRequest openApiRequest = this.urlToApiRequest(url).setAccessToken(accessToken.getAccessToken()).setRequestObject(body).setContextType(requestContextType).setSignKey(accessToken.getRandomKey()).setEncryptionKey(accessToken.getRandomKey());
        if (!GatewayConfig.isIgnoreProviderURL() && !Strings.isNullOrEmpty(accessToken.getProviderAppURL())) {
            openApiRequest.setHost(accessToken.getProviderAppURL());
        }
        this.setRequestHeaders(openApiRequest, requestHeaderMap);
        return this.openHttpClient.post(openApiRequest);
    }

    private void setRequestHeaders(OpenApiRequest openApiRequest, Map<String, Object> requestHeaderMap) {
        if (requestHeaderMap != null && !requestHeaderMap.isEmpty()) {
            openApiRequest.getRequestHeaders().putAll(requestHeaderMap);
        }
    }

    private ExtMapConfig parseExtMapConfig(String responseText) {
        if (responseText == null) {
            return null;
        }
        if (!(responseText.contains("asynchQuery") || responseText.contains("contentEncoding") || responseText.contains("downloadUrl"))) {
            return null;
        }
        OpenApiResponse response = JsonKit.fromJson(responseText, OpenApiResponse.class);
        if (response == null || response.getExtMap() == null) {
            return null;
        }
        logger.debug("ExtMap: {}", (Object)JsonKit.toString(response.getExtMap()));
        ExtMapConfig config = JsonKit.fromJson(JsonKit.toString(response.getExtMap()), ExtMapConfig.class);
        if (config.getAsynchQuery() != null && (Strings.isNullOrEmpty(config.getAsynchQuery().getApiUrl()) || Strings.isNullOrEmpty(config.getAsynchQuery().getRequestBody()))) {
            throw new OpenApiResponseException("100100000004", "\u5f02\u6b65\u67e5\u8be2\u914d\u7f6e\u9519\u8bef\uff1a" + response.getExtMap().get("asynchQuery"), null);
        }
        if (config.getContentEncoding() != null && !"zip".equalsIgnoreCase(config.getContentEncoding())) {
            throw new OpenApiResponseException("100100000005", "\u4e0d\u652f\u6301\u7684\u538b\u7f29\u7b97\u6cd5\uff1a" + config.getContentEncoding(), null);
        }
        response.getExtMap().remove("asynchQuery");
        response.getExtMap().remove("contentEncoding");
        response.getExtMap().remove("downloadUrl");
        config.setResponse(response);
        return config;
    }

    public String requestUser(String url, Object object, String providerAppId, String userToken) {
        String body = this.toJson(object);
        return this.requestUser(url, body, providerAppId, userToken);
    }

    public String requestUser(String url, String body, String providerAppId, String userToken, Map<String, Object> requestHeaderMap) {
        if (Strings.isNullOrEmpty(this.openApiFactory.getGatewayAddress())) {
            OpenApiRequest openApiRequest = this.urlToApiRequest(url);
            this.openApiFactory.setGatewayAddress(openApiRequest.getHost());
        }
        AccessToken accessToken = AccessTokenHelper.getUserAccessToken(this.openApiFactory, providerAppId, userToken);
        return this.requestByAccessToken(url, body, accessToken, OpenApiConstants.DEFAULT_CONTEXT_TYPE, requestHeaderMap);
    }

    public String requestUser(String url, String body, String providerAppId, String userToken) {
        return this.requestUser(url, body, providerAppId, userToken, null);
    }

    private OpenApiRequest urlToApiRequest(String url) {
        URI uri = OpenApiHelper.getUri(url);
        String path = uri.getPath();
        String baseUrl = uri.getScheme() != null && uri.getAuthority() != null ? uri.getScheme() + "://" + uri.getAuthority() : this.openApiFactory.getGatewayAddress();
        String query = uri.getQuery();
        Map<String, String> map = OpenApiHelper.queryStringToMap(query);
        return new OpenApiRequest(path).setHost(baseUrl).setQueryMap(map);
    }

    public boolean isEnabledExtHandling() {
        return this.enabledExtHandling;
    }

    public void setEnabledExtHandling(boolean enabledExtHandling) {
        this.enabledExtHandling = enabledExtHandling;
    }

    public int getAsynchQueryTimeout() {
        return this.asynchQueryTimeout;
    }

    public void setAsynchQueryTimeout(int asynchQueryTimeout) {
        this.asynchQueryTimeout = asynchQueryTimeout;
    }

    private void restRetryCount() {
        this.retryCount.set(1);
    }

    private boolean isMaxRetryCount(int maxRetryCount) {
        return this.retryCount.incrementAndGet() > maxRetryCount;
    }

    public OpenApiClient setGatewayAddress(String gatewayAddress) {
        this.openApiFactory.setGatewayAddress(gatewayAddress);
        return this;
    }
}

