/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.api;

import com.foresee.open.sdk.auth.InternalAccessTokenApi;
import com.foresee.open.sdk.auth.vo.AccessToken;
import com.foresee.open.sdk.client.OpenApiFactory;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AccessTokenHelper {
    private static ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("AccessToken-CacheRefresher-pool-%d").setDaemon(true).build();
    private static ExecutorService parentExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), 100, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(1000, false), threadFactory);
    static final ListeningExecutorService backgroundRefreshPools = MoreExecutors.listeningDecorator((ExecutorService)parentExecutor);
    private static LoadingCache<AccessTokenKey, AccessToken> accessTokenCache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<AccessTokenKey, AccessToken>(){

        public AccessToken load(AccessTokenKey accessTokenKey) {
            return this.generateValue(accessTokenKey);
        }

        private AccessToken generateValue(AccessTokenKey accessTokenKey) {
            InternalAccessTokenApi internalAccessTokenApi = accessTokenKey.openApiFactory.create(InternalAccessTokenApi.class);
            String userToken = accessTokenKey.getUserToken();
            AccessToken accessToken = Strings.isNullOrEmpty((String)userToken) ? internalAccessTokenApi.getByApp(accessTokenKey.getProviderAppId()) : internalAccessTokenApi.getByUserToken(userToken, accessTokenKey.getProviderAppId());
            Integer expireTimes = accessToken.getExpireTimes();
            Date expireDate = new Date(new Date().getTime() + (long)(expireTimes * 1000));
            accessToken.expireDate(expireDate);
            return accessToken;
        }

        public ListenableFuture<AccessToken> reload(final AccessTokenKey key, AccessToken oldValue) throws Exception {
            int deviation = 600000;
            if (oldValue.expireDate().getTime() - new Date().getTime() <= (long)deviation) {
                return Futures.immediateFuture((Object)this.load(key));
            }
            Callable<AccessToken> callable = new Callable<AccessToken>(){

                @Override
                public AccessToken call() {
                    return this.load(key);
                }
            };
            return backgroundRefreshPools.submit((Callable)callable);
        }
    });

    private AccessTokenHelper() {
    }

    public static AccessToken getAppAccessToken(OpenApiFactory openApiFactory, String providerAppId) {
        AccessTokenKey accessTokenKey = new AccessTokenKey(openApiFactory).setConsumerAppId(openApiFactory.getAppId()).setProviderAppId(providerAppId);
        return (AccessToken)accessTokenCache.getUnchecked((Object)accessTokenKey);
    }

    public static AccessToken getUserAccessToken(OpenApiFactory openApiFactory, String providerAppId, String userToken) {
        AccessTokenKey accessTokenKey = new AccessTokenKey(openApiFactory).setConsumerAppId(openApiFactory.getAppId()).setUserToken(userToken).setProviderAppId(providerAppId);
        return (AccessToken)accessTokenCache.getUnchecked((Object)accessTokenKey);
    }

    public static void cleanCache() {
        accessTokenCache.invalidateAll();
    }

    static class AccessTokenKey {
        private OpenApiFactory openApiFactory;
        private String consumerAppId;
        private String providerAppId;
        private String userToken;

        public AccessTokenKey(OpenApiFactory openApiFactory) {
            this.openApiFactory = openApiFactory;
        }

        public String getConsumerAppId() {
            return this.consumerAppId;
        }

        public AccessTokenKey setConsumerAppId(String consumerAppId) {
            this.consumerAppId = consumerAppId;
            return this;
        }

        public String getProviderAppId() {
            return this.providerAppId;
        }

        public AccessTokenKey setProviderAppId(String providerAppId) {
            this.providerAppId = providerAppId;
            return this;
        }

        public String getUserToken() {
            return this.userToken;
        }

        public AccessTokenKey setUserToken(String userToken) {
            this.userToken = userToken;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessTokenKey that = (AccessTokenKey)o;
            return Objects.equals(this.consumerAppId, that.consumerAppId) && Objects.equals(this.providerAppId, that.providerAppId) && Objects.equals(this.userToken, that.userToken);
        }

        public int hashCode() {
            return Objects.hash(this.consumerAppId, this.providerAppId, this.userToken);
        }
    }
}

