/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.client.OpenApiHelper;
import com.foresee.open.sdk.client.OpenApiRequest;
import com.foresee.open.sdk.client.OpenApiResponse;
import com.foresee.open.sdk.client.ssl.SSLConfig;
import com.foresee.open.sdk.client.ssl.SSLHelper;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiClientException;
import com.foresee.open.sdk.exception.OpenApiResponseException;
import com.foresee.open.sdk.json.JsonKit;
import com.foresee.open.sdk.kit.DesKit;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenHttpClient {
    private static final Map<String, String> debugURLs = new HashMap<String, String>();
    private String appId;
    private String encryptKey;
    private OpenApiConstants.EncryptAlgorithm encryptAlgorithm;
    private OpenApiConstants.SignAlgorithm signAlgorithm;
    private String signKey;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String sessionId = UUID.randomUUID().toString().replace("-", "");
    private static final String ua = "FORESEE OPEN-SDK 2.1.4";
    private OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).connectionPool(new ConnectionPool(20, 1L, TimeUnit.MINUTES)).retryOnConnectionFailure(true);
    private OkHttpClient client;

    public OpenHttpClient(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        this.appId = appId;
        this.encryptKey = encryptKey;
        this.encryptAlgorithm = encryptAlgorithm;
        this.signKey = signKey;
        this.signAlgorithm = signAlgorithm;
        if (SSLConfig.isOpenHttpsRequest()) {
            this.builder.sslSocketFactory(SSLHelper.getSSLCertifcation());
        }
        this.client = this.builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String post(OpenApiRequest openApiRequest) {
        Object requestObject = openApiRequest.getRequestObject();
        String requestData = requestObject instanceof String ? (String)requestObject : JsonKit.toString(requestObject);
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        if (openApiRequest.getContextType() != null) {
            JSON = MediaType.parse((String)openApiRequest.getContextType().getContextType());
        }
        TreeMap<String, Object> queryMap = this.genQueryMap(openApiRequest);
        String apiUrl = openApiRequest.getPath();
        String host = openApiRequest.getHost();
        String url = host + apiUrl;
        boolean isDebug = false;
        if (debugURLs.containsKey(apiUrl)) {
            isDebug = true;
            url = debugURLs.get(apiUrl);
        }
        if (!isDebug && this.encryptKey != null) {
            if (this.encryptAlgorithm != OpenApiConstants.EncryptAlgorithm.DES) throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)this.encryptAlgorithm));
            requestData = DesKit.encrypt(this.encryptKey, requestData);
        }
        String queryString = OpenApiHelper.genQueryString(queryMap, openApiRequest.getSignKey(), this.signAlgorithm, requestData);
        url = url + (url.endsWith("?") ? "" : "?") + queryString;
        RequestBody body = RequestBody.create((MediaType)JSON, (String)requestData);
        Request request = new Request.Builder().url(url).addHeader("User-Agent", ua).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            String encryptedRespText = response.body().string();
            if (response.code() != 200) {
                throw new OpenApiClientException(url + " \u8c03\u7528\u63a5\u53e3\u9519\u8bef, http\u9519\u8bef\u7801" + response.code());
            }
            if ((encryptedRespText = encryptedRespText.trim()).startsWith("{")) {
                String string = encryptedRespText;
                return string;
            }
            if (!isDebug && this.encryptKey != null) {
                if (this.encryptAlgorithm != OpenApiConstants.EncryptAlgorithm.DES) throw new OpenApiClientException("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5\uff1a" + (Object)((Object)this.encryptAlgorithm));
                encryptedRespText = DesKit.decryptAndDecompress(this.encryptKey, encryptedRespText);
            }
            String string = encryptedRespText;
            return string;
        }
        catch (IOException e) {
            throw new OpenApiClientException("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    private TreeMap<String, Object> genQueryMap(OpenApiRequest openApiRequest) {
        String requestId = UUID.randomUUID().toString().replace("-", "");
        Map<String, ?> givenQueryMap = openApiRequest.getQueryMap();
        TreeMap<String, Object> queryMap = new TreeMap<String, Object>();
        queryMap.put("appId", this.appId);
        String sessionIdKey = "sessionId";
        String requestIdKey = "requestId";
        String timestampKey = "timestamp";
        String accessTokenKey = "accessToken";
        if (!givenQueryMap.containsKey(sessionIdKey)) {
            queryMap.put(sessionIdKey, this.sessionId);
        }
        if (!givenQueryMap.containsKey(requestIdKey)) {
            queryMap.put(requestIdKey, requestId);
        }
        if (!givenQueryMap.containsKey(timestampKey)) {
            long timestamps = System.currentTimeMillis();
            queryMap.put(timestampKey, String.valueOf(timestamps));
        }
        if (!givenQueryMap.containsKey(accessTokenKey)) {
            queryMap.put(accessTokenKey, openApiRequest.getAccessToken());
        }
        queryMap.putAll(givenQueryMap);
        return queryMap;
    }

    public <T> T execute(OpenApiRequest openApiRequest, Class<T> cls) {
        String respText = this.post(openApiRequest);
        OpenApiResponse entireResponse = JsonKit.fromJson(respText, OpenApiResponse.class);
        if (entireResponse.isFailed()) {
            throw new OpenApiResponseException("\u8bf7\u6c42\u5931\u8d25, " + entireResponse.getHead());
        }
        if (cls == Void.class) {
            return null;
        }
        return entireResponse.getBody(cls);
    }

    public String getSignKey() {
        return this.signKey;
    }

    public OpenHttpClient setSignKey(String signKey) {
        this.signKey = signKey;
        return this;
    }

    public static void addDebugURL(String path, String debugURL) {
        debugURLs.put(path, debugURL);
    }

    public static void removeDebugURL(String path) {
        debugURLs.remove(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String download(String url, int timeoutMills) {
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout((long)timeoutMills, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).build();
        Request request = new Request.Builder().url(url).addHeader("User-Agent", ua).get().build();
        try (Response response = client.newCall(request).execute();){
            String encryptedRespText = response.body().string();
            if (response.code() != 200) {
                throw new OpenApiClientException(url + " \u4e0b\u8f7dAPI\u8c03\u7528\u7ed3\u679c\u9519\u8bef, http\u9519\u8bef\u7801" + response.code());
            }
            String string = encryptedRespText = encryptedRespText.trim();
            return string;
        }
        catch (IOException e) {
            throw new OpenApiClientException("\u4e0b\u8f7dAPI\u8c03\u7528\u7ed3\u679c\u9519\u8bef\uff1a" + url, e);
        }
    }
}

