/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.json.JsonKit;
import java.util.Map;

public class OpenApiResponse<T> {
    private T body;
    private Head head;
    private Map<String, Object> extMap;

    public Head getHead() {
        return this.head;
    }

    public OpenApiResponse<T> setHead(Head head) {
        this.head = head;
        return this;
    }

    public boolean isSuccess() {
        return "0".equals(this.head.errorCode);
    }

    public boolean isFailed() {
        return !this.isSuccess();
    }

    public T getBody() {
        return this.body;
    }

    public T getBody(Class<T> cls) {
        if (this.body == null) {
            return null;
        }
        String json = JsonKit.toString(this.body);
        return JsonKit.fromJson(json, cls);
    }

    public OpenApiResponse<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public Map<String, Object> getExtMap() {
        return this.extMap;
    }

    public void setExtMap(Map<String, Object> extMap) {
        this.extMap = extMap;
    }

    public static class Head {
        private String errorCode;
        private String errorMsg;
        private String requestId;
        private long timestamp;
        private long time;
        private long gtime;
        private long ptime;
        private String errorNo;
        private String sign;

        public String getErrorCode() {
            return this.errorCode;
        }

        public Head setErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Head setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Head setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getGtime() {
            return this.gtime;
        }

        public void setGtime(long gtime) {
            this.gtime = gtime;
        }

        public long getPtime() {
            return this.ptime;
        }

        public void setPtime(long ptime) {
            this.ptime = ptime;
        }

        public String getErrorNo() {
            return this.errorNo;
        }

        public void setErrorNo(String errorNo) {
            this.errorNo = errorNo;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String toString() {
            return "Head{errorCode='" + this.errorCode + '\'' + ", errorMsg='" + this.errorMsg + '\'' + ", requestId='" + this.requestId + '\'' + '}';
        }
    }
}

