/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.api.BaseOpenApi;
import com.foresee.open.sdk.api.OpenApiInvocationHandler;
import com.foresee.open.sdk.api.OpenApiService;
import com.foresee.open.sdk.api.ServiceInfo;
import com.foresee.open.sdk.client.OpenApiClient;
import com.foresee.open.sdk.client.OpenHttpClient;
import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiCreationException;
import com.foresee.open.sdk.exception.OpenApiFactoryException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;

public class OpenApiFactory {
    private String appId;
    private String signKey;
    private OpenHttpClient openHttpClient;
    private Cache<Class<?>, Object> cache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public OpenApiFactory(String appId, String signKey) {
        this(appId, signKey, OpenApiConstants.DEFAULT_SIGN_ALGORITHM, null, OpenApiConstants.DEFAULT_ENCRYPT_ALGORITHM);
    }

    public OpenApiFactory(String appId, String signKey, String encryptKey) {
        this(appId, signKey, OpenApiConstants.DEFAULT_SIGN_ALGORITHM, encryptKey, OpenApiConstants.DEFAULT_ENCRYPT_ALGORITHM);
    }

    public OpenApiFactory(String appId, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String encryptKey, OpenApiConstants.EncryptAlgorithm encryptAlgorithm) {
        this.appId = appId;
        this.signKey = signKey;
        this.openHttpClient = new OpenHttpClient(appId, signKey, signAlgorithm, encryptKey, encryptAlgorithm);
    }

    public <T extends BaseOpenApi> T create(final Class<T> klass) {
        try {
            return (T)((BaseOpenApi)this.cache.get(klass, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return OpenApiFactory.this.doCreate(klass);
                }
            }));
        }
        catch (Exception e) {
            throw new OpenApiCreationException(klass + " api\u521b\u5efa\u5931\u8d25", e);
        }
    }

    private <T extends BaseOpenApi> T doCreate(Class<T> klass) throws Exception {
        this.checkClass(klass);
        ServiceInfo serviceInfo = this.parseServiceInfo(klass);
        T t = this.generate(klass, serviceInfo);
        return t;
    }

    private <T extends BaseOpenApi> ServiceInfo parseServiceInfo(Class<T> klass) {
        ServiceInfo serviceInfo = new ServiceInfo(null, null);
        OpenApiService openApiService = klass.getAnnotation(OpenApiService.class);
        if (openApiService == null && klass.getInterfaces().length > 0) {
            Class<?> clazz;
            Class<?>[] classArray = klass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (openApiService = (clazz = classArray[i]).getAnnotation(OpenApiService.class)) == null; ++i) {
            }
        }
        if (openApiService != null) {
            serviceInfo.setAppId(openApiService.appId());
            serviceInfo.setService(openApiService.name());
        }
        if (serviceInfo.getAppId() == null) {
            throw new RuntimeException(String.format("\u63a5\u53e3[%s]\u672a\u914d\u7f6eappId\u3002", klass.getName()));
        }
        if (serviceInfo.getService() == null) {
            throw new RuntimeException(String.format("\u63a5\u53e3[%s]\u672a\u914d\u7f6e\u670d\u52a1\u540d\u3002", klass.getName()));
        }
        return serviceInfo;
    }

    private <T extends BaseOpenApi> T generate(Class<T> klass, ServiceInfo serviceInfo) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (T)((BaseOpenApi)Proxy.newProxyInstance(classLoader, new Class[]{klass}, (InvocationHandler)new OpenApiInvocationHandler(this, serviceInfo)));
    }

    private <T extends BaseOpenApi> void checkClass(Class<T> klass) {
        if (!klass.isInterface()) {
            throw new OpenApiFactoryException(klass + "\u4e0d\u662f\u4e00\u4e2a\u63a5\u53e3");
        }
        if (!BaseOpenApi.class.isAssignableFrom(klass)) {
            throw new OpenApiFactoryException(klass + "\u6ca1\u6709\u7ee7\u627f" + BaseOpenApi.class);
        }
    }

    public String getServiceInfo() {
        return this.appId;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public OpenHttpClient getOpenHttpClient() {
        return this.openHttpClient;
    }

    public OpenApiClient getOpenApiClient() {
        return new OpenApiClient(this);
    }
}

