/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.kit;

import com.foresee.open.sdk.kit.DigestKit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public abstract class DesKit {
    private static final int BUFFER_SIZE = 2048;

    public static String encrypt(String desKey, String data) {
        try {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(desKey.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)key, sr);
            byte[] bytes = data.getBytes("UTF-8");
            String string = DigestKit.encodeBase64(cipher.doFinal(bytes));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String desKey, String base64Data) {
        try {
            byte[] base64Bytes = DigestKit.decodeBase64(base64Data);
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(desKey.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(2, (Key)key, sr);
            byte[] bytes = cipher.doFinal(base64Bytes);
            return new String(DesKit.decompress(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decompress(byte[] encdata) throws IOException {
        if (encdata == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        InflaterInputStream inflaterInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int count;
            inputStream = new ByteArrayInputStream(encdata);
            inflaterInputStream = new InflaterInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[2048];
            while ((count = inflaterInputStream.read(data, 0, 2048)) != -1) {
                byteArrayOutputStream.write(data, 0, count);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            if (inflaterInputStream != null) {
                inflaterInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }
}

