/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.json.JsonKit;

public class OpenApiResponse {
    private Object body;
    private Head head;

    public Head getHead() {
        return this.head;
    }

    public OpenApiResponse setHead(Head head) {
        this.head = head;
        return this;
    }

    public boolean isSuccess() {
        return "0".equals(this.head.errorCode);
    }

    public boolean isFailed() {
        return !this.isSuccess();
    }

    public Object getBody() {
        return this.body;
    }

    public <T> T getBody(Class<T> cls) {
        if (this.body == null) {
            return null;
        }
        String json = JsonKit.toString(this.body);
        return JsonKit.fromJson(json, cls);
    }

    public OpenApiResponse setBody(Object body) {
        this.body = body;
        return this;
    }

    public static class Head {
        private String errorCode;
        private String errorMsg;
        private String requestId;

        public String getErrorCode() {
            return this.errorCode;
        }

        public Head setErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Head setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Head setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String toString() {
            return "Head{errorCode='" + this.errorCode + '\'' + ", errorMsg='" + this.errorMsg + '\'' + ", requestId='" + this.requestId + '\'' + '}';
        }
    }
}

